/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.vat.industrial_mixer;

import com.drmangotea.tfmg.content.machinery.vat.base.IVatMachine;
import com.drmangotea.tfmg.content.machinery.vat.base.VatBlock;
import com.drmangotea.tfmg.content.machinery.vat.base.VatBlockEntity;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import java.util.Objects;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class IndustrialMixerBlockEntity
extends KineticBlockEntity
implements IVatMachine {
    public MixerMode mixerMode = MixerMode.NONE;
    public int vatSize = 1;
    public int vatHeight = 1;
    public BlockPos vatPos = null;
    LerpedFloat visualSpeed = LerpedFloat.linear();
    float angle;

    public IndustrialMixerBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Override
    public void vatUpdated(VatBlockEntity be) {
        this.vatSize = be.getWidth();
        this.vatHeight = be.getHeight();
        this.vatPos = be.getBlockPos();
    }

    public void tick() {
        super.tick();
        if (!this.level.isClientSide) {
            return;
        }
        float targetSpeed = this.getSpeed();
        this.visualSpeed.updateChaseTarget(targetSpeed);
        this.visualSpeed.tickChaser();
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        for (MixerMode mode : MixerMode.values()) {
            if (mode != this.mixerMode) continue;
            compound.putString("MixerMode", mode.name);
        }
        super.write(compound, registries, clientPacket);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.setMixerMode(compound.getString("MixerMode"), false);
        if (clientPacket) {
            this.visualSpeed.chase((double)this.getGeneratedSpeed(), 0.03125, LerpedFloat.Chaser.EXP);
        }
        super.read(compound, registries, clientPacket);
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.getBlockPos()).inflate(3.0);
    }

    @Override
    public String getOperationId() {
        return switch (this.mixerMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "";
            case 1 -> "tfmg:mixing";
            case 2 -> "tfmg:centrifuge";
        };
    }

    @Override
    public boolean canOperate(VatBlockEntity vat) {
        return this.getSpeed() >= IRotate.SpeedLevel.MEDIUM.getSpeedValue() || this.getSpeed() <= -IRotate.SpeedLevel.MEDIUM.getSpeedValue();
    }

    public boolean setMixerMode(ItemStack modeItem, boolean simulate) {
        for (MixerMode mode : MixerMode.values()) {
            if (!mode.item.is(modeItem.getItem())) continue;
            if (!simulate) {
                this.mixerMode = mode;
                continue;
            }
            return true;
        }
        if (!simulate && this.hasLevel()) {
            VatBlock.updateVatState(this.getBlockState(), this.getLevel(), this.getBlockPos().relative(Direction.DOWN));
        }
        this.sendData();
        return false;
    }

    public boolean setMixerMode(String name, boolean simulate) {
        for (MixerMode mode : MixerMode.values()) {
            if (!Objects.equals(mode.name, name)) continue;
            if (!simulate) {
                this.mixerMode = mode;
                continue;
            }
            return true;
        }
        if (!simulate && this.hasLevel()) {
            VatBlock.updateVatState(this.getBlockState(), this.getLevel(), this.getBlockPos().relative(Direction.DOWN));
        }
        this.sendData();
        return false;
    }

    @Override
    public int getWorkPercentage() {
        return (int)(this.getSpeed() / 255.0f * 100.0f);
    }

    @Override
    public IVatMachine.PositionRequirement getPositionRequirement() {
        return IVatMachine.PositionRequirement.TOP_CENTER;
    }

    @Override
    public String[] doesntWorkWith() {
        return new String[]{"electrodes"};
    }

    static enum MixerMode {
        NONE("none", ItemStack.EMPTY),
        MIXING("mixing", TFMGItems.MIXER_BLADE.asStack()),
        CENTRIFUGE("centrifuge", TFMGItems.CENTRIFUGE.asStack());

        public final String name;
        public final ItemStack item;

        private MixerMode(String name, ItemStack stack) {
            this.name = name;
            this.item = stack;
        }
    }
}

