/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.worldgen;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.worldgen.TFMGFeatures;
import com.drmangotea.tfmg.worldgen.TFMGLayeredPatterns;
import com.drmangotea.tfmg.worldgen.deposits.OilDepositFeature;
import com.drmangotea.tfmg.worldgen.deposits.OilWellFeature;
import com.simibubi.create.infrastructure.worldgen.AllFeatures;
import com.simibubi.create.infrastructure.worldgen.LayerPattern;
import com.simibubi.create.infrastructure.worldgen.LayeredOreConfiguration;
import com.simibubi.create.infrastructure.worldgen.LayeredOreFeature;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class TFMGConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> OIL_DEPOSIT = TFMGConfiguredFeatures.key("oil_deposit");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OIL_WELL = TFMGConfiguredFeatures.key("oil_well");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LEAD_ORE = TFMGConfiguredFeatures.key("lead_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NICKEL_ORE = TFMGConfiguredFeatures.key("nickel_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LITHIUM_ORE = TFMGConfiguredFeatures.key("lithium_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TFMG_STRIATED_ORES_OVERWORLD = TFMGConfiguredFeatures.key("tfmg_striated_ores_overworld");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TFMG_STRIATED_ORES_NETHER = TFMGConfiguredFeatures.key("tfmg_striated_ores_nether");

    private static ResourceKey<ConfiguredFeature<?, ?>> key(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)TFMG.asResource(name));
    }

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> ctx) {
        TagMatchTest stoneOreReplaceables = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepslateOreReplaceables = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        List<OreConfiguration.TargetBlockState> leadTargetStates = List.of(OreConfiguration.target((RuleTest)stoneOreReplaceables, (BlockState)((Block)TFMGBlocks.LEAD_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateOreReplaceables, (BlockState)((Block)TFMGBlocks.DEEPSLATE_LEAD_ORE.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> nickelTargetStates = List.of(OreConfiguration.target((RuleTest)stoneOreReplaceables, (BlockState)((Block)TFMGBlocks.NICKEL_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateOreReplaceables, (BlockState)((Block)TFMGBlocks.DEEPSLATE_NICKEL_ORE.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> lithiumTargetStates = List.of(OreConfiguration.target((RuleTest)stoneOreReplaceables, (BlockState)((Block)TFMGBlocks.LITHIUM_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateOreReplaceables, (BlockState)((Block)TFMGBlocks.DEEPSLATE_LITHIUM_ORE.get()).defaultBlockState()));
        FeatureUtils.register(ctx, OIL_DEPOSIT, (Feature)((OilDepositFeature)((Object)TFMGFeatures.OIL_DEPOSIT.get())), (FeatureConfiguration)new NoneFeatureConfiguration());
        FeatureUtils.register(ctx, OIL_WELL, (Feature)((OilWellFeature)((Object)TFMGFeatures.OIL_WELL.get())), (FeatureConfiguration)new NoneFeatureConfiguration());
        FeatureUtils.register(ctx, LEAD_ORE, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(leadTargetStates, 12));
        FeatureUtils.register(ctx, NICKEL_ORE, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(nickelTargetStates, 10));
        FeatureUtils.register(ctx, LITHIUM_ORE, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(lithiumTargetStates, 7));
        List<LayerPattern> overworldLayerPatterns = List.of((LayerPattern)TFMGLayeredPatterns.BAUXITE.get(), (LayerPattern)TFMGLayeredPatterns.GALENA.get(), (LayerPattern)TFMGLayeredPatterns.LIGNITE.get(), (LayerPattern)TFMGLayeredPatterns.FIRECLAY.get());
        FeatureUtils.register(ctx, TFMG_STRIATED_ORES_OVERWORLD, (Feature)((LayeredOreFeature)AllFeatures.LAYERED_ORE.get()), (FeatureConfiguration)new LayeredOreConfiguration(overworldLayerPatterns, 32, 0.0f));
        List<LayerPattern> netherLayerPatterns = List.of((LayerPattern)TFMGLayeredPatterns.SULFUR.get(), (LayerPattern)TFMGLayeredPatterns.FIRECLAY_NETHER.get());
        FeatureUtils.register(ctx, TFMG_STRIATED_ORES_NETHER, (Feature)((LayeredOreFeature)AllFeatures.LAYERED_ORE.get()), (FeatureConfiguration)new LayeredOreConfiguration(netherLayerPatterns, 32, 0.0f));
    }
}

