/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import xyz.przemyk.simpleplanes.blocks.PlaneWorkbenchBlockEntity;
import xyz.przemyk.simpleplanes.container.PlaneWorkbenchContainer;

public class PlaneWorkbenchBlock
extends Block
implements EntityBlock {
    public static final Component CONTAINER_NAME = Component.translatable((String)"simpleplanes.container.plane_workbench");

    public PlaneWorkbenchBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        if (pLevel.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        PlaneWorkbenchBlockEntity planeWorkbenchBlockEntity = (PlaneWorkbenchBlockEntity)pLevel.getBlockEntity(pPos);
        if (planeWorkbenchBlockEntity != null) {
            SimpleMenuProvider menu = new SimpleMenuProvider((id, inventory, player) -> new PlaneWorkbenchContainer(id, inventory, pPos, planeWorkbenchBlockEntity.itemStackHandler, planeWorkbenchBlockEntity.selectedRecipe), CONTAINER_NAME);
            pPlayer.openMenu((MenuProvider)menu);
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new PlaneWorkbenchBlockEntity(blockPos, blockState);
    }

    public void onRemove(BlockState state, Level level, BlockPos blockPos, BlockState newState, boolean isMoving) {
        PlaneWorkbenchBlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = (PlaneWorkbenchBlockEntity)level.getBlockEntity(blockPos)) != null) {
            Containers.dropItemStack((Level)level, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), (ItemStack)blockEntity.itemStackHandler.getStackInSlot(0));
            Containers.dropItemStack((Level)level, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), (ItemStack)blockEntity.itemStackHandler.getStackInSlot(1));
        }
        super.onRemove(state, level, blockPos, newState, isMoving);
    }
}

