/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix4f;
import xyz.przemyk.simpleplanes.client.gui.PlaneInventoryScreen;

public class ClientUtil {
    public static void renderTiledTextureAtlas(GuiGraphics guiGraphics, AbstractContainerScreen<?> screen, TextureAtlasSprite sprite, int x, int y, int width, int height, int depth) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.atlasLocation());
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        float u1 = sprite.getU0();
        float v1 = sprite.getV0();
        int spriteHeight = sprite.contents().height();
        int spriteWidth = sprite.contents().width();
        int startX = x + screen.getGuiLeft();
        int startY = y + screen.getGuiTop();
        do {
            int renderWidth;
            int renderHeight = Math.min(spriteHeight, height);
            height -= renderHeight;
            float v2 = sprite.getV(16.0f * (float)renderHeight / (float)spriteHeight);
            int x2 = startX;
            int widthLeft = width;
            Matrix4f matrix = guiGraphics.pose().last().pose();
            do {
                renderWidth = Math.min(spriteWidth, widthLeft);
                float u2 = sprite.getU(16.0f * (float)renderWidth / (float)spriteWidth);
                ClientUtil.buildSquare(matrix, builder, x2, x2 + renderWidth, startY, startY + renderHeight, depth, u1, u2, v1, v2);
                x2 += renderWidth;
            } while ((widthLeft -= renderWidth) > 0);
            startY += renderHeight;
        } while (height > 0);
        MeshData meshData = builder.build();
        if (meshData != null) {
            BufferUploader.drawWithShader((MeshData)meshData);
        }
    }

    private static void buildSquare(Matrix4f matrix, BufferBuilder builder, int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2) {
        builder.addVertex(matrix, (float)x1, (float)y2, (float)z).setUv(u1, v2);
        builder.addVertex(matrix, (float)x2, (float)y2, (float)z).setUv(u2, v2);
        builder.addVertex(matrix, (float)x2, (float)y1, (float)z).setUv(u2, v1);
        builder.addVertex(matrix, (float)x1, (float)y1, (float)z).setUv(u1, v1);
    }

    public static int alpha(int c) {
        return c >> 24 & 0xFF;
    }

    public static int red(int c) {
        return c >> 16 & 0xFF;
    }

    public static int green(int c) {
        return c >> 8 & 0xFF;
    }

    public static int blue(int c) {
        return c & 0xFF;
    }

    public static void setColorRGBA(int color) {
        float a = (float)ClientUtil.alpha(color) / 255.0f;
        float r = (float)ClientUtil.red(color) / 255.0f;
        float g = (float)ClientUtil.green(color) / 255.0f;
        float b = (float)ClientUtil.blue(color) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }

    public static void renderLiquidEngineFluid(GuiGraphics guiGraphics, PlaneInventoryScreen screen, FluidStack fluidStack, int height, int width, int fluidHeight) {
        TextureAtlasSprite fluidSprite = (TextureAtlasSprite)screen.getMinecraft().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getStillTexture(fluidStack));
        ClientUtil.renderTiledTextureAtlas(guiGraphics, screen, fluidSprite, 153, 25 + height - 2 - fluidHeight, width - 4, fluidHeight, 100);
    }
}

