/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.villager_retraining_plus;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.z2six.villager_retraining_plus.Villager_retraining_plus;

@EventBusSubscriber(modid="villager_retraining_plus")
public final class Config {
    private static final ModConfigSpec.Builder B = new ModConfigSpec.Builder();
    public static final ModConfigSpec.ConfigValue<String> COST_ITEM_OR_TAG = B.comment("Item or tag to consume per reroll (exactly one string):\n  - vanilla emerald: \"minecraft:emerald\"\n  - Lightman's Currency coins (normal):\n    \"lightmanscurrency:coin_copper\"\n    \"lightmanscurrency:coin_iron\"\n    \"lightmanscurrency:coin_gold\"\n    \"lightmanscurrency:coin_emerald\"\n    \"lightmanscurrency:coin_diamond\"\n    \"lightmanscurrency:coin_netherite\"\n  - Lightman's Currency chocolate coins (if your pack enables them), e.g.:\n    \"lightmanscurrency:coin_chocolate_copper\"\n    \"lightmanscurrency:coin_chocolate_emerald\"\n  - any tag: \"#minecraft:logs\"  (applies to inventory payment only)\n").define("cost.itemOrTag", (Object)"minecraft:emerald");
    public static final ModConfigSpec.IntValue COST_COUNT = B.comment("Base count to consume per reroll (before scaling)").defineInRange("cost.count", 16, 0, 640);
    public static final ModConfigSpec.BooleanValue SCALE_BY_LEVEL = B.comment("Multiply cost by villager level (1..5). Default true.").define("cost.scaleByLevel", true);
    public static final ModConfigSpec.BooleanValue PREFER_WALLET = B.comment("If true and Lightman's Currency is installed, attempt to withdraw the cost\nfrom the player's LC Wallet first. If that fails, fall back to inventory.\n").define("cost.preferWallet", true);
    public static final ModConfigSpec.BooleanValue AUTO_DEFAULT_LC_IF_PRESENT = B.comment("QoL: If LC is installed and cost.itemOrTag is still \"minecraft:emerald\",\nauto-switch to \"lightmanscurrency:coin_emerald\" on load (logged).\n").define("cost.autoPreferLCIfPresent", true);
    public static final ModConfigSpec.IntValue COOLDOWN_TICKS = B.comment("Cooldown in ticks per villager between rerolls (0 = disabled)").defineInRange("limits.cooldownTicks", 200, 0, 20000);
    public static final ModConfigSpec.IntValue PER_VILLAGER_DAILY = B.comment("Maximum rerolls per villager per Minecraft day (0 = disabled)").defineInRange("limits.perVillagerDaily", 0, 0, 100);
    public static final ModConfigSpec.BooleanValue ALLOW_AFTER_TRADE_USED = B.comment("Allow reroll even if villager has XP / trades were used. Default true.").define("behavior.allowAfterTradeUsed", true);
    public static final ModConfigSpec SPEC = B.build();
    public static String costSpec;
    public static int costCount;
    public static boolean scaleByLevel;
    public static int cooldownTicks;
    public static int perVillagerDaily;
    public static boolean allowAfterTradeUsed;
    public static boolean preferWallet;
    public static boolean autoPreferLCIfPresent;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        try {
            costSpec = (String)COST_ITEM_OR_TAG.get();
            costCount = (Integer)COST_COUNT.get();
            scaleByLevel = (Boolean)SCALE_BY_LEVEL.get();
            cooldownTicks = (Integer)COOLDOWN_TICKS.get();
            perVillagerDaily = (Integer)PER_VILLAGER_DAILY.get();
            allowAfterTradeUsed = (Boolean)ALLOW_AFTER_TRADE_USED.get();
            preferWallet = (Boolean)PREFER_WALLET.get();
            autoPreferLCIfPresent = (Boolean)AUTO_DEFAULT_LC_IF_PRESENT.get();
            if (autoPreferLCIfPresent && ModList.get().isLoaded("lightmanscurrency") && "minecraft:emerald".equals(costSpec)) {
                costSpec = "lightmanscurrency:coin_emerald";
                Villager_retraining_plus.LOG().info("[VRP] Lightman's Currency detected. Auto-switching cost.itemOrTag to '{}'", (Object)costSpec);
            }
            Villager_retraining_plus.LOG().info("[VRP] Config loaded: cost='{}' x{}, scaleByLevel={}, cooldown={}, dailyCap={}, allowAfterUsed={}, preferWallet={}, autoPreferLCIfPresent={}", new Object[]{costSpec, costCount, scaleByLevel, cooldownTicks, perVillagerDaily, allowAfterTradeUsed, preferWallet, autoPreferLCIfPresent});
        }
        catch (Throwable t) {
            Villager_retraining_plus.LOG().error("[VRP] Config load error", t);
        }
    }

    public static boolean isTagSpec(String s) {
        return s != null && s.startsWith("#");
    }

    public static TagKey<Item> asItemTag(String s) {
        if (!Config.isTagSpec(s)) {
            return null;
        }
        ResourceLocation id = ResourceLocation.tryParse((String)s.substring(1));
        return id == null ? null : TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)id);
    }
}

