/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.villager_retraining_plus.logic;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.z2six.villager_retraining_plus.Villager_retraining_plus;

public final class CostUtil {
    public static Ingredient parseIngredient(String spec) {
        try {
            if (spec == null || spec.isBlank()) {
                return Ingredient.EMPTY;
            }
            if ((spec = spec.trim()).startsWith("#")) {
                ResourceLocation id = ResourceLocation.tryParse((String)spec.substring(1));
                if (id == null) {
                    return Ingredient.EMPTY;
                }
                TagKey tag = TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)id);
                return Ingredient.of((TagKey)tag);
            }
            ResourceLocation id = ResourceLocation.tryParse((String)spec);
            if (id == null) {
                return Ingredient.EMPTY;
            }
            Item item = (Item)BuiltInRegistries.ITEM.get(id);
            if (item == null) {
                return Ingredient.EMPTY;
            }
            return Ingredient.of((ItemLike[])new ItemLike[]{item});
        }
        catch (Throwable t) {
            Villager_retraining_plus.LOG().error("[VRP] parseIngredient failed for '{}'", (Object)spec, (Object)t);
            return Ingredient.EMPTY;
        }
    }

    public static boolean consume(ServerPlayer sp, Ingredient ing, int count) {
        try {
            Inventory inv = sp.getInventory();
            int remaining = count;
            for (int i = 0; i < inv.getContainerSize(); ++i) {
                ItemStack s = inv.getItem(i);
                if (s.isEmpty() || !ing.test(s)) continue;
                int take = Math.min(remaining, s.getCount());
                s.shrink(take);
                if ((remaining -= take) <= 0) break;
            }
            if (remaining > 0) {
                Villager_retraining_plus.LOG().info("[VRP] Not enough items: need {}, short by {}", (Object)count, (Object)remaining);
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            Villager_retraining_plus.LOG().error("[VRP] consume() exception", t);
            return false;
        }
    }
}

