/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.villager_retraining_plus.logic;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.ModList;
import org.z2six.villager_retraining_plus.Villager_retraining_plus;

public final class MoneyBridge {
    private static volatile boolean lookedUp = false;
    private static volatile boolean lcPresent = false;
    private static Class<?> clsMoneyAPI;
    private static Class<?> clsIMoneyHandler;
    private static Class<?> clsMoneyValue;
    private static Class<?> clsCoinValue;
    private static Method mMoneyAPI_getPlayersMoneyHandler;
    private static Method mIMoneyHandler_extractMoney;
    private static Method mMoneyValue_isEmpty;
    private static Method mCoinValue_fromItem_long;
    private static Method mCoinValue_fromItem_int;
    private static Method mCoinValue_fromStack_long;
    private static Method mCoinValue_fromStack_int;
    private static Object moneyApiTarget;
    private static Object moneyApiCompanion;

    public static boolean isLCPresent() {
        if (!lookedUp) {
            lcPresent = ModList.get().isLoaded("lightmanscurrency");
            lookedUp = true;
            if (lcPresent) {
                Villager_retraining_plus.LOG().info("[VRP] LC present: binding MoneyAPI (factory path)...");
                MoneyBridge.bind();
            } else {
                Villager_retraining_plus.LOG().info("[VRP] LC not present: MoneyAPI disabled.");
            }
        }
        if (lcPresent && !MoneyBridge.areBound()) {
            Villager_retraining_plus.LOG().info("[VRP] MoneyAPI not fully bound; retrying bind...");
            MoneyBridge.bind();
            if (!MoneyBridge.areBound()) {
                Villager_retraining_plus.LOG().info("[VRP] MoneyAPI still not fully bound after retry.");
            }
        }
        return lcPresent;
    }

    public static boolean canAfford(ServerPlayer player, ResourceLocation coinId, int count) {
        try {
            if (!MoneyBridge.isLCPresent() || !MoneyBridge.areBound()) {
                return false;
            }
            if (coinId == null || count <= 0) {
                return true;
            }
            Item coinItem = (Item)BuiltInRegistries.ITEM.get(coinId);
            if (coinItem == null) {
                return false;
            }
            Object moneyValue = MoneyBridge.buildMoneyValue(coinItem, count);
            if (moneyValue == null) {
                return false;
            }
            Object handler = MoneyBridge.invokeHandlerGetter(player);
            if (handler == null) {
                return false;
            }
            Object remainderSim = mIMoneyHandler_extractMoney.invoke(handler, moneyValue, Boolean.TRUE);
            return MoneyBridge.isMoneyEmpty(remainderSim);
        }
        catch (Throwable t) {
            Villager_retraining_plus.LOG().info("[VRP] MoneyAPI: canAfford simulate failed: {}", (Object)t.toString());
            return false;
        }
    }

    public static boolean tryExtract(ServerPlayer player, ResourceLocation coinId, int count) {
        try {
            if (!MoneyBridge.isLCPresent() || !MoneyBridge.areBound()) {
                Villager_retraining_plus.LOG().info("[VRP] MoneyAPI not bound; falling back.");
                return false;
            }
            if (coinId == null || count <= 0) {
                return true;
            }
            Item coinItem = (Item)BuiltInRegistries.ITEM.get(coinId);
            if (coinItem == null) {
                Villager_retraining_plus.LOG().info("[VRP] MoneyAPI: item '{}' not found.", (Object)coinId);
                return false;
            }
            Object moneyValue = MoneyBridge.buildMoneyValue(coinItem, count);
            if (moneyValue == null) {
                Villager_retraining_plus.LOG().info("[VRP] MoneyAPI: failed to build MoneyValue for {} x {}", (Object)count, (Object)coinId);
                return false;
            }
            Object handler = MoneyBridge.invokeHandlerGetter(player);
            Villager_retraining_plus.LOG().info("[VRP] MoneyAPI: handler -> {}", (Object)(handler == null ? "null" : handler.getClass().getName()));
            if (handler == null) {
                return false;
            }
            Object remainderSim = mIMoneyHandler_extractMoney.invoke(handler, moneyValue, Boolean.TRUE);
            boolean simOK = MoneyBridge.isMoneyEmpty(remainderSim);
            Villager_retraining_plus.LOG().info("[VRP] MoneyAPI: simulate isEmpty -> {}", (Object)simOK);
            if (!simOK) {
                return false;
            }
            Object remainderReal = mIMoneyHandler_extractMoney.invoke(handler, moneyValue, Boolean.FALSE);
            boolean realOK = MoneyBridge.isMoneyEmpty(remainderReal);
            Villager_retraining_plus.LOG().info("[VRP] MoneyAPI: real isEmpty -> {}", (Object)realOK);
            return realOK;
        }
        catch (Throwable t) {
            Villager_retraining_plus.LOG().warn("[VRP] MoneyAPI extract failed (soft): {}", (Object)t.toString());
            return false;
        }
    }

    private static void bind() {
        try {
            clsMoneyAPI = Class.forName("io.github.lightman314.lightmanscurrency.api.money.MoneyAPI");
            clsIMoneyHandler = Class.forName("io.github.lightman314.lightmanscurrency.api.capability.money.IMoneyHandler");
            clsMoneyValue = Class.forName("io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue");
            clsCoinValue = Class.forName("io.github.lightman314.lightmanscurrency.api.money.value.builtin.CoinValue");
            mMoneyAPI_getPlayersMoneyHandler = MoneyBridge.tryGetHandlerGetter(clsMoneyAPI);
            if (mMoneyAPI_getPlayersMoneyHandler != null && !Modifier.isStatic(mMoneyAPI_getPlayersMoneyHandler.getModifiers())) {
                try {
                    Object v;
                    Field f = clsMoneyAPI.getDeclaredField("API");
                    f.setAccessible(true);
                    if (Modifier.isStatic(f.getModifiers()) && (v = f.get(null)) != null) {
                        moneyApiTarget = v;
                        Villager_retraining_plus.LOG().info("[VRP] MoneyAPI bind: using MoneyAPI.API singleton -> {}", (Object)v.getClass().getName());
                    }
                }
                catch (NoSuchFieldException f) {
                    // empty catch block
                }
                if (moneyApiTarget == null) {
                    MoneyBridge.resolveMoneyApiInstances(clsMoneyAPI);
                }
            } else if (mMoneyAPI_getPlayersMoneyHandler != null) {
                Villager_retraining_plus.LOG().info("[VRP] MoneyAPI bind: handler getter is STATIC");
            }
            mIMoneyHandler_extractMoney = clsIMoneyHandler.getMethod("extractMoney", clsMoneyValue, Boolean.TYPE);
            mIMoneyHandler_extractMoney.setAccessible(true);
            Villager_retraining_plus.LOG().info("[VRP] MoneyAPI bind: IMoneyHandler#extractMoney(...) OK");
            mMoneyValue_isEmpty = clsMoneyValue.getMethod("isEmpty", new Class[0]);
            mMoneyValue_isEmpty.setAccessible(true);
            Villager_retraining_plus.LOG().info("[VRP] MoneyAPI bind: MoneyValue#isEmpty() OK");
            MoneyBridge.bindCoinValueFactories();
            Villager_retraining_plus.LOG().info("[VRP] MoneyAPI bound check: getter={}, static={}, hasAPIorInstance={}, hasCompanion={}, extractMoney={}, factories(item,long|int; stack,long|int)={}|{};{}|{}, isEmpty={}", new Object[]{mMoneyAPI_getPlayersMoneyHandler != null, mMoneyAPI_getPlayersMoneyHandler != null && Modifier.isStatic(mMoneyAPI_getPlayersMoneyHandler.getModifiers()), moneyApiTarget != null, moneyApiCompanion != null, mIMoneyHandler_extractMoney != null, mCoinValue_fromItem_long != null, mCoinValue_fromItem_int != null, mCoinValue_fromStack_long != null, mCoinValue_fromStack_int != null, mMoneyValue_isEmpty != null});
        }
        catch (Throwable t) {
            Villager_retraining_plus.LOG().warn("[VRP] MoneyBridge.bind failed: {}", (Object)t.toString());
        }
    }

    private static boolean areBound() {
        boolean handlerOK = mMoneyAPI_getPlayersMoneyHandler == null ? false : (Modifier.isStatic(mMoneyAPI_getPlayersMoneyHandler.getModifiers()) ? true : moneyApiTarget != null || moneyApiCompanion != null);
        return clsMoneyAPI != null && clsIMoneyHandler != null && clsMoneyValue != null && clsCoinValue != null && handlerOK && mIMoneyHandler_extractMoney != null && mMoneyValue_isEmpty != null && (mCoinValue_fromItem_long != null || mCoinValue_fromItem_int != null || mCoinValue_fromStack_long != null || mCoinValue_fromStack_int != null);
    }

    private static Method tryGetHandlerGetter(Class<?> moneyAPI) {
        String[] names = new String[]{"GetPlayersMoneyHandler", "getPlayersMoneyHandler", "GetPlayerMoneyHandler", "getPlayerMoneyHandler", "GetMoneyHandler", "getMoneyHandler"};
        Class[] params = new Class[]{Player.class, ServerPlayer.class, LivingEntity.class, Entity.class};
        for (String n : names) {
            for (Class p : params) {
                try {
                    Method m = moneyAPI.getMethod(n, p);
                    m.setAccessible(true);
                    Villager_retraining_plus.LOG().info("[VRP] MoneyAPI bind: MoneyAPI#{}({}) OK", (Object)n, (Object)p.getSimpleName());
                    return m;
                }
                catch (NoSuchMethodException m) {
                    try {
                        Method m2 = moneyAPI.getDeclaredMethod(n, p);
                        m2.setAccessible(true);
                        Villager_retraining_plus.LOG().info("[VRP] MoneyAPI bind: MoneyAPI#declared {}({}) OK", (Object)n, (Object)p.getSimpleName());
                        return m2;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
            }
        }
        Villager_retraining_plus.LOG().info("[VRP] MoneyAPI bind: handler getter not found (tried common names)");
        return null;
    }

    private static void resolveMoneyApiInstances(Class<?> moneyAPI) {
        Object[] constants2;
        try {
            if (moneyAPI.isEnum() && (constants2 = moneyAPI.getEnumConstants()) != null && constants2.length > 0) {
                moneyApiTarget = constants2[0];
                Villager_retraining_plus.LOG().info("[VRP] MoneyAPI bind: using enum constant as instance.");
                return;
            }
        }
        catch (Throwable constants2) {
            // empty catch block
        }
        constants2 = new String[]{"INSTANCE", "Instance", "instance"};
        int n = constants2.length;
        for (int i = 0; i < n; ++i) {
            Object fn = constants2[i];
            try {
                Object v;
                Field f = null;
                try {
                    f = moneyAPI.getField((String)fn);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                if (f == null) {
                    f = moneyAPI.getDeclaredField((String)fn);
                }
                f.setAccessible(true);
                if (!Modifier.isStatic(f.getModifiers()) || (v = f.get(null)) == null) continue;
                moneyApiTarget = v;
                return;
            }
            catch (Throwable f) {
                // empty catch block
            }
        }
        try {
            Object v;
            String[] f = null;
            try {
                f = moneyAPI.getField("Companion");
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (f == null) {
                f = moneyAPI.getDeclaredField("Companion");
            }
            f.setAccessible(true);
            if (Modifier.isStatic(f.getModifiers()) && (v = f.get(null)) != null) {
                moneyApiCompanion = v;
            }
        }
        catch (Throwable f) {
            // empty catch block
        }
        for (String mn : new String[]{"get", "getInstance", "instance"}) {
            try {
                Method m = null;
                try {
                    m = moneyAPI.getMethod(mn, new Class[0]);
                }
                catch (NoSuchMethodException v) {
                    // empty catch block
                }
                if (m == null) {
                    m = moneyAPI.getDeclaredMethod(mn, new Class[0]);
                }
                m.setAccessible(true);
                if (!Modifier.isStatic(m.getModifiers()) || (v = m.invoke(null, new Object[0])) == null) continue;
                moneyApiTarget = v;
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            Constructor<?> c = moneyAPI.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            Object v = c.newInstance(new Object[0]);
            if (v != null) {
                moneyApiTarget = v;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void bindCoinValueFactories() {
        try {
            for (Method m : clsCoinValue.getMethods()) {
                if (!Modifier.isStatic(m.getModifiers()) || !clsMoneyValue.isAssignableFrom(m.getReturnType())) continue;
                Class<?>[] p = m.getParameterTypes();
                if (p.length == 2 && p[0] == Item.class && p[1] == Long.TYPE) {
                    mCoinValue_fromItem_long = m;
                    continue;
                }
                if (p.length == 2 && p[0] == Item.class && p[1] == Integer.TYPE) {
                    mCoinValue_fromItem_int = m;
                    continue;
                }
                if (p.length == 2 && p[0] == ItemStack.class && p[1] == Long.TYPE) {
                    mCoinValue_fromStack_long = m;
                    continue;
                }
                if (p.length != 2 || p[0] != ItemStack.class || p[1] != Integer.TYPE) continue;
                mCoinValue_fromStack_int = m;
            }
            Villager_retraining_plus.LOG().info("[VRP] MoneyAPI bind: CoinValue factories -> item,long={}, item,int={}, stack,long={}, stack,int={}", new Object[]{mCoinValue_fromItem_long != null, mCoinValue_fromItem_int != null, mCoinValue_fromStack_long != null, mCoinValue_fromStack_int != null});
        }
        catch (Throwable t) {
            Villager_retraining_plus.LOG().warn("[VRP] MoneyAPI bind: scanning CoinValue factories failed: {}", (Object)t.toString());
        }
    }

    private static Object buildMoneyValue(Item coinItem, int count) {
        try {
            if (count <= 0) {
                count = 1;
            }
            if (mCoinValue_fromItem_long != null) {
                return mCoinValue_fromItem_long.invoke(null, coinItem, count);
            }
            if (mCoinValue_fromItem_int != null) {
                return mCoinValue_fromItem_int.invoke(null, coinItem, count);
            }
            ItemStack stack = new ItemStack((ItemLike)coinItem, count);
            if (mCoinValue_fromStack_long != null) {
                return mCoinValue_fromStack_long.invoke(null, stack, count);
            }
            if (mCoinValue_fromStack_int != null) {
                return mCoinValue_fromStack_int.invoke(null, stack, count);
            }
            return null;
        }
        catch (Throwable t) {
            Villager_retraining_plus.LOG().warn("[VRP] MoneyAPI: buildMoneyValue failed: {}", (Object)t.toString());
            return null;
        }
    }

    private static boolean isMoneyEmpty(Object moneyValue) {
        try {
            Boolean b;
            if (moneyValue == null) {
                return true;
            }
            Object r = mMoneyValue_isEmpty.invoke(moneyValue, new Object[0]);
            return r instanceof Boolean && (b = (Boolean)r) != false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static Object invokeHandlerGetter(ServerPlayer player) {
        try {
            ServerPlayer arg;
            if (mMoneyAPI_getPlayersMoneyHandler == null) {
                return null;
            }
            Class<?> p = mMoneyAPI_getPlayersMoneyHandler.getParameterTypes()[0];
            ServerPlayer serverPlayer = p == Player.class ? player : (p == ServerPlayer.class ? player : (p == LivingEntity.class ? player : (arg = p == Entity.class ? player : player)));
            if (Modifier.isStatic(mMoneyAPI_getPlayersMoneyHandler.getModifiers())) {
                return mMoneyAPI_getPlayersMoneyHandler.invoke(null, arg);
            }
            if (moneyApiTarget != null) {
                return mMoneyAPI_getPlayersMoneyHandler.invoke(moneyApiTarget, arg);
            }
            if (moneyApiCompanion != null) {
                return mMoneyAPI_getPlayersMoneyHandler.invoke(moneyApiCompanion, arg);
            }
            return null;
        }
        catch (Throwable t) {
            Villager_retraining_plus.LOG().info("[VRP] MoneyAPI: invoke handler getter failed: {}", (Object)t.toString());
            return null;
        }
    }

    private MoneyBridge() {
    }
}

