/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.villager_retraining_plus.logic;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.trading.Merchant;
import org.z2six.villager_retraining_plus.Config;
import org.z2six.villager_retraining_plus.Villager_retraining_plus;
import org.z2six.villager_retraining_plus.logic.CostUtil;
import org.z2six.villager_retraining_plus.logic.MoneyBridge;
import org.z2six.villager_retraining_plus.logic.RerollState;
import org.z2six.villager_retraining_plus.logic.TradeUtil;
import org.z2six.villager_retraining_plus.logic.WalletBridge;
import org.z2six.villager_retraining_plus.mixin.MerchantMenuAccessor;

public final class RerollExecutor {
    public static void tryReroll(ServerPlayer sp) {
        try {
            int offersBefore;
            AbstractContainerMenu abstractContainerMenu = sp.containerMenu;
            if (!(abstractContainerMenu instanceof MerchantMenu)) {
                return;
            }
            MerchantMenu menu = (MerchantMenu)abstractContainerMenu;
            if (menu.getSlot(2).hasItem()) {
                RerollExecutor.toast(sp, "vrp.msg.mid_trade");
                Villager_retraining_plus.LOG().info("[VRP] Reroll refused: result slot occupied (player={})", (Object)sp.getGameProfile().getName());
                return;
            }
            Merchant trader = ((MerchantMenuAccessor)menu).vrp$getTrader();
            if (!(trader instanceof Villager)) {
                RerollExecutor.toast(sp, "vrp.msg.not_villager");
                Villager_retraining_plus.LOG().info("[VRP] Reroll refused: trader is not a Villager (player={})", (Object)sp.getGameProfile().getName());
                return;
            }
            Villager vill = (Villager)trader;
            int level = Math.max(1, Math.min(5, vill.getVillagerData().getLevel()));
            int xp = vill.getVillagerXp();
            int n = offersBefore = vill.getOffers() != null ? vill.getOffers().size() : -1;
            if (!RerollState.canReroll(sp, vill)) {
                RerollExecutor.toast(sp, "vrp.msg.cooldown_or_cap");
                Villager_retraining_plus.LOG().info("[VRP] Reroll refused: cooldown/cap (player={}, villager={})", (Object)sp.getGameProfile().getName(), (Object)vill.getUUID());
                return;
            }
            if (!Config.allowAfterTradeUsed && xp > 0) {
                RerollExecutor.toast(sp, "vrp.msg.after_used_disabled");
                Villager_retraining_plus.LOG().info("[VRP] Reroll refused: allowAfterTradeUsed=false (player={}, villager={})", (Object)sp.getGameProfile().getName(), (Object)vill.getUUID());
                return;
            }
            int base = Math.max(0, Config.costCount);
            int cost = Config.scaleByLevel ? base * level : base;
            Villager_retraining_plus.LOG().info("[VRP] Reroll attempt: player={}, villager={}, prof={}, level={}, xp={}, baseCost={}, scaledCost={}, costSpec='{}' (preferWallet={})", new Object[]{sp.getGameProfile().getName(), vill.getUUID(), vill.getVillagerData().getProfession(), level, xp, base, cost, Config.costSpec, Config.preferWallet});
            boolean paid = false;
            if (cost > 0) {
                boolean isExactItem;
                ResourceLocation itemId = ResourceLocation.tryParse((String)Config.costSpec);
                boolean bl = isExactItem = itemId != null && !Config.isTagSpec(Config.costSpec);
                if (Config.preferWallet && isExactItem && MoneyBridge.isLCPresent()) {
                    boolean apiPaid = MoneyBridge.tryExtract(sp, itemId, cost);
                    if (apiPaid) {
                        Villager_retraining_plus.LOG().info("[VRP] Cost paid via LC MoneyAPI: {} x {}", (Object)cost, (Object)itemId);
                        paid = true;
                    } else {
                        Villager_retraining_plus.LOG().info("[VRP] LC MoneyAPI extraction unavailable/failed; trying direct wallet next: {} x {}", (Object)cost, (Object)itemId);
                    }
                }
                if (!paid && Config.preferWallet && isExactItem && WalletBridge.isLCPresent()) {
                    boolean walletPaid = WalletBridge.tryWithdrawFromWallet(sp, itemId, cost);
                    if (walletPaid) {
                        Villager_retraining_plus.LOG().info("[VRP] Cost paid via LC wallet (direct): {} x {}", (Object)cost, (Object)itemId);
                        paid = true;
                    } else {
                        Villager_retraining_plus.LOG().info("[VRP] LC direct wallet unavailable/failed; falling back to inventory: {} x {}", (Object)cost, (Object)itemId);
                    }
                }
                if (!paid) {
                    Ingredient ing = CostUtil.parseIngredient(Config.costSpec);
                    if (ing == Ingredient.EMPTY || !CostUtil.consume(sp, ing, cost)) {
                        RerollExecutor.toast(sp, "vrp.msg.not_enough");
                        Villager_retraining_plus.LOG().info("[VRP] Reroll refused: insufficient inventory for {} x {}", (Object)cost, (Object)Config.costSpec);
                        return;
                    }
                    Villager_retraining_plus.LOG().info("[VRP] Cost consumed from inventory: {} x {}", (Object)cost, (Object)Config.costSpec);
                    paid = true;
                }
            } else {
                Villager_retraining_plus.LOG().info("[VRP] Cost is zero (free reroll per config).");
            }
            if (!TradeUtil.rebuildOffers(vill, sp)) {
                Villager_retraining_plus.LOG().warn("[VRP] Reroll failed during rebuild (villager={})", (Object)vill.getUUID());
                RerollExecutor.toast(sp, "vrp.msg.failed");
                return;
            }
            int offersAfter = vill.getOffers() != null ? vill.getOffers().size() : -1;
            RerollState.markRerolled(sp, vill);
            RerollExecutor.toast(sp, "vrp.msg.success");
            Villager_retraining_plus.LOG().info("[VRP] Reroll success: villager={}, offers {} -> {}, player={}, paid={}", new Object[]{vill.getUUID(), offersBefore, offersAfter, sp.getGameProfile().getName(), cost <= 0 ? "free" : (paid ? "yes" : "no")});
        }
        catch (Throwable t) {
            Villager_retraining_plus.LOG().error("[VRP] tryReroll exception", t);
        }
    }

    private static void toast(ServerPlayer sp, String key) {
        sp.displayClientMessage((Component)Component.translatable((String)key), true);
    }

    private RerollExecutor() {
    }
}

