/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.villager_retraining_plus.logic;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.trading.MerchantOffers;
import org.z2six.villager_retraining_plus.Villager_retraining_plus;
import org.z2six.villager_retraining_plus.mixin.AbstractVillagerAccessor;
import org.z2six.villager_retraining_plus.mixin.VillagerAccessor;

public final class TradeUtil {
    public static boolean rebuildOffers(Villager vill, ServerPlayer player) {
        try {
            VillagerData original = vill.getVillagerData();
            int targetLevel = Math.max(1, Math.min(5, original.getLevel()));
            int oldSize = vill.getOffers() != null ? vill.getOffers().size() : -1;
            ((AbstractVillagerAccessor)vill).vrp$setOffers(new MerchantOffers());
            for (int l = 1; l <= targetLevel; ++l) {
                VillagerData step = new VillagerData(original.getType(), original.getProfession(), l);
                vill.setVillagerData(step);
                ((VillagerAccessor)vill).vrp$updateTrades();
            }
            vill.setVillagerData(original);
            ((VillagerAccessor)vill).vrp$updateSpecialPrices((Player)player);
            MerchantOffers offers = vill.getOffers();
            int newSize = offers != null ? offers.size() : -1;
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof MerchantMenu) {
                MerchantMenu menu = (MerchantMenu)abstractContainerMenu;
                player.sendMerchantOffers(menu.containerId, offers, vill.getVillagerData().getLevel(), vill.getVillagerXp(), vill.showProgressBar(), vill.canRestock());
                Villager_retraining_plus.LOG().info("[VRP] Rebuilt offers via vanilla steps: villager={}, level={}, offers {} -> {}", new Object[]{vill.getUUID(), targetLevel, oldSize, newSize});
            } else {
                Villager_retraining_plus.LOG().warn("[VRP] Player not in MerchantMenu during sync; GUI may not refresh (villager={}, offers={})", (Object)vill.getUUID(), (Object)newSize);
            }
            return true;
        }
        catch (Throwable t) {
            Villager_retraining_plus.LOG().error("[VRP] rebuildOffers exception", t);
            return false;
        }
    }

    private TradeUtil() {
    }
}

