/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.villager_retraining_plus.network;

import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.z2six.villager_retraining_plus.Villager_retraining_plus;
import org.z2six.villager_retraining_plus.network.ClientTooltipCache;
import org.z2six.villager_retraining_plus.network.PacketRequestReroll;
import org.z2six.villager_retraining_plus.network.PacketTooltipData;
import org.z2six.villager_retraining_plus.network.PacketTooltipQuery;
import org.z2six.villager_retraining_plus.network.ServerHandlers;
import org.z2six.villager_retraining_plus.server.TooltipService;

@EventBusSubscriber(modid="villager_retraining_plus")
public final class Network {
    private Network() {
    }

    public static void init() {
    }

    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent e) {
        PayloadRegistrar r = e.registrar("villager_retraining_plus");
        r.playToServer(PacketTooltipQuery.TYPE, PacketTooltipQuery.STREAM_CODEC, (msg, ctx) -> Network.handleTooltipQueryServer(msg, ctx));
        r.playToServer(PacketRequestReroll.TYPE, PacketRequestReroll.STREAM_CODEC, (msg, ctx) -> Network.handleRerollServer(msg, ctx));
        r.playToClient(PacketTooltipData.TYPE, PacketTooltipData.STREAM_CODEC, (msg, ctx) -> Network.handleTooltipDataClient(msg, ctx));
        Villager_retraining_plus.LOG().info("[VRP] Network payloads registered.");
    }

    public static void sendToServer(CustomPacketPayload payload) {
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc == null || mc.getConnection() == null) {
                Villager_retraining_plus.LOG().warn("[VRP] sendToServer: no client connection; dropping {}", (Object)payload.type());
                return;
            }
            mc.getConnection().send((Packet)new ServerboundCustomPayloadPacket(payload));
        }
        catch (Throwable t) {
            Villager_retraining_plus.LOG().error("[VRP] sendToServer failed for {}", (Object)payload.getClass().getName(), (Object)t);
        }
    }

    public static void sendToServer(PacketRequestReroll msg) {
        Network.sendToServer((CustomPacketPayload)msg);
    }

    public static void sendToServer(PacketTooltipQuery msg) {
        Network.sendToServer((CustomPacketPayload)msg);
    }

    private static void handleTooltipQueryServer(PacketTooltipQuery msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            try {
                Player player = ctx.player();
                if (!(player instanceof ServerPlayer)) {
                    return;
                }
                ServerPlayer sp = (ServerPlayer)player;
                PacketTooltipData data = TooltipService.computeSnapshot(sp, msg.traderEntityId());
                ctx.reply((CustomPacketPayload)data);
            }
            catch (Throwable t) {
                Villager_retraining_plus.LOG().error("[VRP] TooltipQuery handler error", t);
            }
        });
    }

    private static void handleRerollServer(PacketRequestReroll msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            try {
                ServerHandlers.handleReroll(msg, ctx);
            }
            catch (Throwable t) {
                Villager_retraining_plus.LOG().error("[VRP] Reroll handler error", t);
            }
        });
    }

    private static void handleTooltipDataClient(PacketTooltipData msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            try {
                ClientTooltipCache.set(msg);
            }
            catch (Throwable t) {
                Villager_retraining_plus.LOG().error("[VRP] TooltipData client handler error", t);
            }
        });
    }
}

