/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.villager_retraining_plus.server;

import java.lang.reflect.Method;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.z2six.villager_retraining_plus.Villager_retraining_plus;
import org.z2six.villager_retraining_plus.logic.MoneyBridge;
import org.z2six.villager_retraining_plus.network.PacketTooltipData;

public final class TooltipService {
    public static PacketTooltipData computeSnapshot(ServerPlayer player, int traderEntityId) {
        PacketTooltipData out = new PacketTooltipData();
        try {
            Entity e;
            Villager vill = null;
            if (traderEntityId >= 0 && (e = player.level().getEntity(traderEntityId)) instanceof Villager) {
                Villager v;
                vill = v = (Villager)e;
            }
            int villLevel = vill != null ? vill.getVillagerData().getLevel() : 1;
            int villXp = vill != null ? vill.getVillagerXp() : 0;
            ResourceLocation costItem = Cfg.costItemRL();
            int baseCost = Cfg.baseCost();
            boolean freeMode = Cfg.freeMode();
            boolean scaleByLevel = Cfg.scaleByLevel();
            boolean scaleByXp = Cfg.scaleByXp();
            int levelStep = Cfg.levelStepCost();
            int xpPerStep = Cfg.xpPerStep();
            int xpStepCost = Cfg.xpStepCost();
            int maxCapCost = Cfg.maxCostCap();
            boolean preferWallet = Cfg.preferWallet();
            int scaled = freeMode ? 0 : TooltipService.scaleCost(baseCost, scaleByLevel, levelStep, scaleByXp, xpPerStep, xpStepCost, maxCapCost, villLevel, villXp);
            out.cost.item = costItem;
            out.cost.baseCost = baseCost;
            out.cost.scaledCost = scaled;
            out.cost.nextCostIfUsed = TooltipService.predictNextCost(baseCost, scaled, scaleByLevel, levelStep, scaleByXp, xpPerStep, xpStepCost, maxCapCost, villLevel, villXp);
            out.cost.maxCostPossible = maxCapCost > 0 ? Integer.valueOf(maxCapCost) : null;
            out.villager.level = villLevel;
            out.villager.xp = villXp;
            if (scaled <= 0) {
                out.afford.canAfford = true;
                out.afford.source = "none";
            } else {
                boolean can;
                Item item;
                boolean walletOK = false;
                boolean invOK = false;
                if (preferWallet && MoneyBridge.isLCPresent()) {
                    walletOK = MoneyBridge.canAfford(player, costItem, scaled);
                }
                if ((item = (Item)BuiltInRegistries.ITEM.get(costItem)) != null) {
                    int invCount = TooltipService.countInInventory(player, item);
                    invOK = invCount >= scaled;
                }
                out.afford.canAfford = can = walletOK || invOK;
                out.afford.source = can ? (walletOK && invOK ? "both" : (walletOK ? "wallet" : "inventory")) : "none";
            }
            boolean capEnabled = Cfg.dailyCapEnabled();
            int cap = Cfg.dailyCap();
            out.cap.enabled = capEnabled && cap > 0;
            out.cap.cap = cap;
            out.cap.remaining = out.cap.enabled ? Cfg.remainingToday(player) : -1;
            out.cap.resetMode = Cfg.resetModeKey();
            out.cap.intervalSeconds = Cfg.resetIntervalSeconds();
            out.cap.resetAnchorEpochMs = Cfg.resetAnchorEpochMs();
            out.cap.nextResetEpochMs = Cfg.nextResetEpochMs();
            out.cfg.version = Cfg.version();
            out.cfg.hash = Cfg.hash();
            out.cfg.scaleByLevel = scaleByLevel;
            out.cfg.preferWallet = preferWallet;
            out.cfg.freeMode = freeMode;
            out.cfg.capEnabled = out.cap.enabled;
        }
        catch (Throwable t) {
            Villager_retraining_plus.LOG().error("[VRP] TooltipService.computeSnapshot failed", t);
        }
        return out;
    }

    private static int scaleCost(int base, boolean scaleByLevel, int levelStep, boolean scaleByXp, int xpPerStep, int xpStepCost, int maxCostCap, int villLevel, int villXp) {
        try {
            long result = base;
            if (scaleByLevel) {
                int levelMinus1 = Math.max(0, villLevel - 1);
                result += (long)levelMinus1 * (long)levelStep;
            }
            if (scaleByXp && xpPerStep > 0 && xpStepCost > 0) {
                result += (long)(Math.max(0, villXp) / xpPerStep) * (long)xpStepCost;
            }
            if (maxCostCap > 0) {
                result = Math.min(result, (long)maxCostCap);
            }
            return (int)Math.max(0L, Math.min(Integer.MAX_VALUE, result));
        }
        catch (Throwable t) {
            return base;
        }
    }

    private static Integer predictNextCost(int base, int currentScaled, boolean scaleByLevel, int levelStep, boolean scaleByXp, int xpPerStep, int xpStepCost, int maxCostCap, int villLevel, int villXp) {
        try {
            if (!scaleByLevel && !scaleByXp) {
                return null;
            }
            int next = TooltipService.scaleCost(base, scaleByLevel, levelStep, scaleByXp, xpPerStep, xpStepCost, maxCostCap, Math.min(5, Math.max(1, villLevel)), villXp);
            return next != currentScaled ? Integer.valueOf(next) : null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static int countInInventory(ServerPlayer player, Item item) {
        int total = 0;
        try {
            Inventory inv = player.getInventory();
            for (int i = 0; i < inv.getContainerSize(); ++i) {
                ItemStack s = inv.getItem(i);
                if (s.isEmpty() || s.getItem() != item) continue;
                total += s.getCount();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return total;
    }

    private TooltipService() {
    }

    private static final class Cfg {
        private static final String CFG_CLASS = "org.z2six.villager_retraining_plus.Config";

        private Cfg() {
        }

        private static Class<?> cfg() {
            try {
                return Class.forName(CFG_CLASS);
            }
            catch (Throwable t) {
                return null;
            }
        }

        private static Object call(String name, Class<?> ret, Object def, Class<?> ... sig) {
            try {
                Class<?> c = Cfg.cfg();
                if (c == null) {
                    return def;
                }
                Method m = c.getMethod(name, sig);
                Object v = m.invoke(null, new Object[0]);
                return v == null ? def : v;
            }
            catch (Throwable ignored) {
                return def;
            }
        }

        static ResourceLocation costItemRL() {
            Object v = Cfg.call("costItemRL", Object.class, null, new Class[0]);
            if (v instanceof ResourceLocation) {
                ResourceLocation rl = (ResourceLocation)v;
                return rl;
            }
            return ResourceLocation.withDefaultNamespace((String)"emerald");
        }

        static int baseCost() {
            return (Integer)Cfg.call("baseCost", Integer.TYPE, 16, new Class[0]);
        }

        static boolean freeMode() {
            return (Boolean)Cfg.call("freeMode", Boolean.TYPE, false, new Class[0]);
        }

        static boolean scaleByLevel() {
            return (Boolean)Cfg.call("scaleByLevel", Boolean.TYPE, true, new Class[0]);
        }

        static boolean scaleByXp() {
            return (Boolean)Cfg.call("scaleByXp", Boolean.TYPE, false, new Class[0]);
        }

        static int levelStepCost() {
            return (Integer)Cfg.call("levelStepCost", Integer.TYPE, 4, new Class[0]);
        }

        static int xpPerStep() {
            return (Integer)Cfg.call("xpPerStep", Integer.TYPE, 20, new Class[0]);
        }

        static int xpStepCost() {
            return (Integer)Cfg.call("xpStepCost", Integer.TYPE, 1, new Class[0]);
        }

        static int maxCostCap() {
            return (Integer)Cfg.call("maxCostCap", Integer.TYPE, 64, new Class[0]);
        }

        static boolean preferWallet() {
            return (Boolean)Cfg.call("preferWallet", Boolean.TYPE, true, new Class[0]);
        }

        static boolean dailyCapEnabled() {
            return (Boolean)Cfg.call("dailyCapEnabled", Boolean.TYPE, false, new Class[0]);
        }

        static int dailyCap() {
            return (Integer)Cfg.call("dailyCap", Integer.TYPE, 0, new Class[0]);
        }

        static int remainingToday(ServerPlayer p) {
            return (Integer)Cfg.call("remainingToday", Integer.TYPE, -1, ServerPlayer.class);
        }

        static String resetModeKey() {
            return (String)Cfg.call("resetModeKey", String.class, "NEVER", new Class[0]);
        }

        static int resetIntervalSeconds() {
            return (Integer)Cfg.call("resetIntervalSeconds", Integer.TYPE, 0, new Class[0]);
        }

        static long resetAnchorEpochMs() {
            return (Long)Cfg.call("resetAnchorEpochMs", Long.TYPE, 0L, new Class[0]);
        }

        static long nextResetEpochMs() {
            return (Long)Cfg.call("nextResetEpochMs", Long.TYPE, 0L, new Class[0]);
        }

        static int version() {
            return (Integer)Cfg.call("cfgVersion", Integer.TYPE, 1, new Class[0]);
        }

        static int hash() {
            return (Integer)Cfg.call("cfgHash", Integer.TYPE, 464367618, new Class[0]);
        }
    }
}

