/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.content.items;

import com.kyanite.deeperdarker.content.DDDataComponents;
import com.kyanite.deeperdarker.content.DDItems;
import com.kyanite.deeperdarker.content.DDSounds;
import com.kyanite.deeperdarker.content.datacomponents.Transmitter;
import com.kyanite.deeperdarker.util.DDTags;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

public class SculkTransmitterItem
extends Item {
    public SculkTransmitterItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        BlockPos clickedPos = context.getClickedPos();
        if (SculkTransmitterItem.isLinked(stack)) {
            return SculkTransmitterItem.transmit(level, player, stack, clickedPos);
        }
        if (!SculkTransmitterItem.canConnect(level, clickedPos)) {
            SculkTransmitterItem.tryConnect(null, stack, player, null, "not_transmittable", DDSounds.TRANSMITTER_ERROR);
            return InteractionResult.FAIL;
        }
        SculkTransmitterItem.tryConnect(Transmitter.empty(), stack, player, clickedPos, "linked", DDSounds.TRANSMITTER_LINK);
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (SculkTransmitterItem.isLinked(player.getMainHandItem())) {
            SculkTransmitterItem.transmit(level, player, player.getMainHandItem(), null);
        }
        return super.use(level, player, usedHand);
    }

    public static InteractionResult transmit(Level level, Player player, ItemStack stack, BlockPos clickedPos) {
        Transmitter transmitter = (Transmitter)stack.get(DDDataComponents.TRANSMITTER);
        if (transmitter.linkedPos().isEmpty()) {
            return InteractionResult.FAIL;
        }
        BlockPos linkedPos = transmitter.linkedPos().get().pos();
        if (player.isCrouching()) {
            if (clickedPos != null && SculkTransmitterItem.canConnect(level, clickedPos)) {
                SculkTransmitterItem.tryConnect(transmitter, stack, player, clickedPos, "linked", DDSounds.TRANSMITTER_LINK);
                return InteractionResult.SUCCESS;
            }
            SculkTransmitterItem.tryConnect(transmitter, stack, player, null, "unlinked", DDSounds.TRANSMITTER_UNLINK);
            return InteractionResult.FAIL;
        }
        if (!level.isLoaded(linkedPos)) {
            SculkTransmitterItem.tryConnect(null, stack, player, null, "not_found", DDSounds.TRANSMITTER_ERROR);
            return InteractionResult.FAIL;
        }
        if (!SculkTransmitterItem.canConnect(level, linkedPos)) {
            SculkTransmitterItem.tryConnect(transmitter, stack, player, null, "not_found", DDSounds.TRANSMITTER_ERROR);
            return InteractionResult.FAIL;
        }
        level.gameEvent((Holder)GameEvent.ENTITY_INTERACT, player.blockPosition(), GameEvent.Context.of((Entity)player));
        MenuProvider menu = level.getBlockState(linkedPos).getMenuProvider(level, linkedPos);
        if (menu != null) {
            BlockEntity blockEntity;
            player.playSound((SoundEvent)DDSounds.TRANSMITTER_OPEN.get(), 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.openMenu(menu);
            }
            if ((blockEntity = level.getBlockEntity(linkedPos)) instanceof ChestBlockEntity) {
                ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
                chest.startOpen(player);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public static boolean isLinked(ItemStack stack) {
        return stack.is(DDItems.SCULK_TRANSMITTER) && stack.has(DDDataComponents.TRANSMITTER) && ((Transmitter)stack.get(DDDataComponents.TRANSMITTER)).linkedPos().isPresent();
    }

    private static boolean canConnect(Level level, BlockPos target) {
        return level.getBlockState(target).is(DDTags.Blocks.TRANSMITTABLE);
    }

    public static void tryConnect(Transmitter transmitter, ItemStack stack, Player player, BlockPos pos, String key, DeferredHolder<SoundEvent, SoundEvent> sound) {
        player.displayClientMessage((Component)Component.translatable((String)("block.deeperdarker." + key)), true);
        player.playSound((SoundEvent)sound.get());
        if (transmitter != null) {
            transmitter = transmitter.newConnection(player.level(), pos);
            stack.set(DDDataComponents.TRANSMITTER, (Object)transmitter);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (SculkTransmitterItem.isLinked(stack)) {
            Transmitter transmitter = (Transmitter)stack.get(DDDataComponents.TRANSMITTER);
            BlockPos pos = transmitter.linkedPos().get().pos();
            tooltipComponents.add((Component)Component.translatable((String)"tooltips.deeperdarker.sculk_transmitter.linked", (Object[])new Object[]{Component.translatable((String)transmitter.savedBlock())}).withStyle(ChatFormatting.GRAY));
            tooltipComponents.add((Component)Component.translatable((String)"tooltips.deeperdarker.sculk_transmitter.location", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}).withStyle(ChatFormatting.GRAY));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltips.deeperdarker.sculk_transmitter.not_linked").withStyle(ChatFormatting.GRAY));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

