/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.datagen.data;

import com.kyanite.deeperdarker.DeeperDarker;
import com.kyanite.deeperdarker.content.DDBlocks;
import com.kyanite.deeperdarker.content.DDItems;
import com.kyanite.deeperdarker.util.DDTags;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;

public class DDRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public DDRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(@NotNull RecipeOutput recipeOutput) {
        this.addCraftingRecipes(recipeOutput);
        this.addCookingRecipes(recipeOutput);
        this.addStonecuttingRecipes(recipeOutput);
        this.addSmithingRecipes(recipeOutput);
    }

    private void addCraftingRecipes(RecipeOutput output) {
        this.woodenRecipes(output, DDTags.Items.ECHO_LOGS, DDBlocks.STRIPPED_ECHO_LOG, DDBlocks.ECHO_PLANKS, DDBlocks.ECHO_STAIRS, DDBlocks.ECHO_SLAB, DDBlocks.ECHO_FENCE, DDBlocks.ECHO_FENCE_GATE, DDBlocks.ECHO_DOOR, DDBlocks.ECHO_TRAPDOOR, DDBlocks.ECHO_PRESSURE_PLATE, DDBlocks.ECHO_BUTTON, DDItems.ECHO_SIGN, DDItems.ECHO_HANGING_SIGN, DDItems.ECHO_BOAT, DDItems.ECHO_CHEST_BOAT);
        DDRecipeProvider.woodFromLogs((RecipeOutput)output, DDBlocks.ECHO_WOOD, DDBlocks.ECHO_LOG);
        DDRecipeProvider.woodFromLogs((RecipeOutput)output, DDBlocks.STRIPPED_ECHO_WOOD, DDBlocks.STRIPPED_ECHO_LOG);
        this.woodenRecipes(output, DDTags.Items.BLOOM_STEMS, DDBlocks.STRIPPED_BLOOMING_STEM, DDBlocks.BLOOM_PLANKS, DDBlocks.BLOOM_STAIRS, DDBlocks.BLOOM_SLAB, DDBlocks.BLOOM_FENCE, DDBlocks.BLOOM_FENCE_GATE, DDBlocks.BLOOM_DOOR, DDBlocks.BLOOM_TRAPDOOR, DDBlocks.BLOOM_PRESSURE_PLATE, DDBlocks.BLOOM_BUTTON, DDItems.BLOOM_SIGN, DDItems.BLOOM_HANGING_SIGN, DDItems.BLOOM_BOAT, DDItems.BLOOM_CHEST_BOAT);
        DDRecipeProvider.stairBuilder(DDBlocks.SCULK_STONE_STAIRS, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{DDBlocks.SCULK_STONE})).unlockedBy("has_sculk_stone", DDRecipeProvider.has(DDBlocks.SCULK_STONE)).save(output);
        DDRecipeProvider.slab((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.SCULK_STONE_SLAB, DDBlocks.SCULK_STONE);
        DDRecipeProvider.wall((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.SCULK_STONE_WALL, DDBlocks.SCULK_STONE);
        DDRecipeProvider.stairBuilder(DDBlocks.COBBLED_SCULK_STONE_STAIRS, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{DDBlocks.COBBLED_SCULK_STONE})).unlockedBy("has_cobbled_sculk_stone", DDRecipeProvider.has(DDBlocks.COBBLED_SCULK_STONE)).save(output);
        DDRecipeProvider.slab((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.COBBLED_SCULK_STONE_SLAB, DDBlocks.COBBLED_SCULK_STONE);
        DDRecipeProvider.wall((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.COBBLED_SCULK_STONE_WALL, DDBlocks.COBBLED_SCULK_STONE);
        DDRecipeProvider.polished((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.POLISHED_SCULK_STONE, DDBlocks.COBBLED_SCULK_STONE);
        DDRecipeProvider.stairBuilder(DDBlocks.POLISHED_SCULK_STONE_STAIRS, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{DDBlocks.POLISHED_SCULK_STONE})).unlockedBy("has_polished_sculk_stone", DDRecipeProvider.has(DDBlocks.POLISHED_SCULK_STONE)).save(output);
        DDRecipeProvider.slab((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.POLISHED_SCULK_STONE_SLAB, DDBlocks.POLISHED_SCULK_STONE);
        DDRecipeProvider.wall((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.POLISHED_SCULK_STONE_WALL, DDBlocks.POLISHED_SCULK_STONE);
        DDRecipeProvider.polished((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.SCULK_STONE_BRICKS, DDBlocks.POLISHED_SCULK_STONE);
        DDRecipeProvider.stairBuilder(DDBlocks.SCULK_STONE_BRICK_STAIRS, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{DDBlocks.SCULK_STONE_BRICKS})).unlockedBy("has_sculk_stone_bricks", DDRecipeProvider.has(DDBlocks.SCULK_STONE_BRICKS)).save(output);
        DDRecipeProvider.slab((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.SCULK_STONE_BRICK_SLAB, DDBlocks.SCULK_STONE_BRICKS);
        DDRecipeProvider.wall((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.SCULK_STONE_BRICK_WALL, DDBlocks.SCULK_STONE_BRICKS);
        DDRecipeProvider.polished((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.SCULK_STONE_TILES, DDBlocks.SCULK_STONE_BRICKS);
        DDRecipeProvider.stairBuilder(DDBlocks.SCULK_STONE_TILE_STAIRS, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{DDBlocks.SCULK_STONE_TILES})).unlockedBy("has_sculk_stone_tiles", DDRecipeProvider.has(DDBlocks.SCULK_STONE_TILES)).save(output);
        DDRecipeProvider.slab((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.SCULK_STONE_TILE_SLAB, DDBlocks.SCULK_STONE_TILES);
        DDRecipeProvider.wall((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.SCULK_STONE_TILE_WALL, DDBlocks.SCULK_STONE_TILES);
        DDRecipeProvider.stairBuilder(DDBlocks.SMOOTH_SCULK_STONE_STAIRS, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{DDBlocks.SMOOTH_SCULK_STONE})).unlockedBy("has_smooth_sculk_stone", DDRecipeProvider.has(DDBlocks.SMOOTH_SCULK_STONE)).save(output);
        DDRecipeProvider.slab((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.SMOOTH_SCULK_STONE_SLAB, DDBlocks.SMOOTH_SCULK_STONE);
        DDRecipeProvider.wall((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.SMOOTH_SCULK_STONE_WALL, DDBlocks.SMOOTH_SCULK_STONE);
        DDRecipeProvider.polished((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.CUT_SCULK_STONE, DDBlocks.SMOOTH_SCULK_STONE);
        DDRecipeProvider.stairBuilder(DDBlocks.CUT_SCULK_STONE_STAIRS, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{DDBlocks.CUT_SCULK_STONE})).unlockedBy("has_cut_sculk_stone", DDRecipeProvider.has(DDBlocks.CUT_SCULK_STONE)).save(output);
        DDRecipeProvider.slab((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.CUT_SCULK_STONE_SLAB, DDBlocks.CUT_SCULK_STONE);
        DDRecipeProvider.wall((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.CUT_SCULK_STONE_WALL, DDBlocks.CUT_SCULK_STONE);
        DDRecipeProvider.chiseledBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.CHISELED_SCULK_STONE, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{DDBlocks.SCULK_STONE_BRICK_SLAB})).unlockedBy("has_sculk_stone_slab", DDRecipeProvider.has(DDBlocks.SCULK_STONE_BRICK_SLAB)).save(output);
        DDRecipeProvider.stairBuilder(DDBlocks.GLOOMSLATE_STAIRS, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{DDBlocks.GLOOMSLATE})).unlockedBy("has_gloomslate", DDRecipeProvider.has(DDBlocks.GLOOMSLATE)).save(output);
        DDRecipeProvider.slab((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.GLOOMSLATE_SLAB, DDBlocks.GLOOMSLATE);
        DDRecipeProvider.wall((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.GLOOMSLATE_WALL, DDBlocks.GLOOMSLATE);
        DDRecipeProvider.stairBuilder(DDBlocks.COBBLED_GLOOMSLATE_STAIRS, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{DDBlocks.COBBLED_GLOOMSLATE})).unlockedBy("has_cobbled_gloomslate", DDRecipeProvider.has(DDBlocks.COBBLED_GLOOMSLATE)).save(output);
        DDRecipeProvider.slab((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.COBBLED_GLOOMSLATE_SLAB, DDBlocks.COBBLED_GLOOMSLATE);
        DDRecipeProvider.wall((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.COBBLED_GLOOMSLATE_WALL, DDBlocks.COBBLED_GLOOMSLATE);
        DDRecipeProvider.polished((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.POLISHED_GLOOMSLATE, DDBlocks.COBBLED_GLOOMSLATE);
        DDRecipeProvider.stairBuilder(DDBlocks.POLISHED_GLOOMSLATE_STAIRS, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{DDBlocks.POLISHED_GLOOMSLATE})).unlockedBy("has_polished_gloomslate", DDRecipeProvider.has(DDBlocks.POLISHED_GLOOMSLATE)).save(output);
        DDRecipeProvider.slab((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.POLISHED_GLOOMSLATE_SLAB, DDBlocks.POLISHED_GLOOMSLATE);
        DDRecipeProvider.wall((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.POLISHED_GLOOMSLATE_WALL, DDBlocks.POLISHED_GLOOMSLATE);
        DDRecipeProvider.polished((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.GLOOMSLATE_BRICKS, DDBlocks.POLISHED_GLOOMSLATE);
        DDRecipeProvider.stairBuilder(DDBlocks.GLOOMSLATE_BRICK_STAIRS, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{DDBlocks.GLOOMSLATE_BRICKS})).unlockedBy("has_gloomslate_bricks", DDRecipeProvider.has(DDBlocks.GLOOMSLATE_BRICKS)).save(output);
        DDRecipeProvider.slab((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.GLOOMSLATE_BRICK_SLAB, DDBlocks.GLOOMSLATE_BRICKS);
        DDRecipeProvider.wall((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.GLOOMSLATE_BRICK_WALL, DDBlocks.GLOOMSLATE_BRICKS);
        DDRecipeProvider.polished((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.GLOOMSLATE_TILES, DDBlocks.GLOOMSLATE_BRICKS);
        DDRecipeProvider.stairBuilder(DDBlocks.GLOOMSLATE_TILE_STAIRS, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{DDBlocks.GLOOMSLATE_TILES})).unlockedBy("has_gloomslate_tiles", DDRecipeProvider.has(DDBlocks.GLOOMSLATE_TILES)).save(output);
        DDRecipeProvider.slab((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.GLOOMSLATE_TILE_SLAB, DDBlocks.GLOOMSLATE_TILES);
        DDRecipeProvider.wall((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.GLOOMSLATE_TILE_WALL, DDBlocks.GLOOMSLATE_TILES);
        DDRecipeProvider.stairBuilder(DDBlocks.SMOOTH_GLOOMSLATE_STAIRS, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{DDBlocks.SMOOTH_GLOOMSLATE})).unlockedBy("has_smooth_gloomslate", DDRecipeProvider.has(DDBlocks.SMOOTH_GLOOMSLATE)).save(output);
        DDRecipeProvider.slab((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.SMOOTH_GLOOMSLATE_SLAB, DDBlocks.SMOOTH_GLOOMSLATE);
        DDRecipeProvider.wall((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.SMOOTH_GLOOMSLATE_WALL, DDBlocks.SMOOTH_GLOOMSLATE);
        DDRecipeProvider.polished((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.CUT_GLOOMSLATE, DDBlocks.SMOOTH_GLOOMSLATE);
        DDRecipeProvider.stairBuilder(DDBlocks.CUT_GLOOMSLATE_STAIRS, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{DDBlocks.CUT_GLOOMSLATE})).unlockedBy("has_cut_gloomslate", DDRecipeProvider.has(DDBlocks.CUT_GLOOMSLATE)).save(output);
        DDRecipeProvider.slab((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.CUT_GLOOMSLATE_SLAB, DDBlocks.CUT_GLOOMSLATE);
        DDRecipeProvider.wall((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.CUT_GLOOMSLATE_WALL, DDBlocks.CUT_GLOOMSLATE);
        DDRecipeProvider.chiseledBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.CHISELED_GLOOMSLATE, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{DDBlocks.GLOOMSLATE_BRICK_SLAB})).unlockedBy("has_gloomslate_slab", DDRecipeProvider.has(DDBlocks.GLOOMSLATE_BRICK_SLAB)).save(output);
        DDRecipeProvider.twoByTwoPacker((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.SCULK_GRIME, DDItems.GRIME_BALL);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.SCULK_GRIME_BRICKS).define(Character.valueOf('G'), DDItems.GRIME_BRICK).pattern("GG").pattern("GG").unlockedBy("has_grime_brick", DDRecipeProvider.has(DDItems.GRIME_BRICK)).save(output);
        DDRecipeProvider.stairBuilder(DDBlocks.SCULK_GRIME_BRICK_STAIRS, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{DDBlocks.SCULK_GRIME_BRICKS})).unlockedBy("has_sculk_grime_bricks", DDRecipeProvider.has(DDBlocks.SCULK_GRIME_BRICKS)).save(output);
        DDRecipeProvider.slab((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.SCULK_GRIME_BRICK_SLAB, DDBlocks.SCULK_GRIME_BRICKS);
        DDRecipeProvider.wall((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.SCULK_GRIME_BRICK_WALL, DDBlocks.SCULK_GRIME_BRICKS);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, DDBlocks.SOUNDPROOF_GLASS, (int)2).define(Character.valueOf('S'), DDItems.SOUL_DUST).define(Character.valueOf('G'), (ItemLike)Items.GLASS).pattern(" S ").pattern("SGS").pattern(" S ").unlockedBy(DDRecipeProvider.getHasName(DDItems.SOUL_DUST), DDRecipeProvider.has(DDItems.SOUL_DUST)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, DDItems.SOUL_ELYTRA).define(Character.valueOf('B'), DDItems.SCULK_BONE).define(Character.valueOf('C'), DDItems.SOUL_CRYSTAL).define(Character.valueOf('D'), DDItems.SOUL_DUST).define(Character.valueOf('E'), (ItemLike)Items.ELYTRA).pattern("BCB").pattern("DED").pattern("B B").unlockedBy("has_elytra", DDRecipeProvider.has((ItemLike)Items.ELYTRA)).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, DDItems.RESONARIUM_PLATE).requires(DDItems.RESONARIUM, 4).requires(Ingredient.of(DDTags.Items.SCUTES), 4).unlockedBy(DDRecipeProvider.getHasName(DDItems.RESONARIUM), DDRecipeProvider.has(DDItems.RESONARIUM)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, DDItems.REINFORCED_ECHO_SHARD).define(Character.valueOf('P'), (ItemLike)Items.PHANTOM_MEMBRANE).define(Character.valueOf('C'), DDItems.WARDEN_CARAPACE).define(Character.valueOf('E'), (ItemLike)Items.ECHO_SHARD).pattern("PCP").pattern("CEC").pattern("PCP").unlockedBy(DDRecipeProvider.getHasName(DDItems.WARDEN_CARAPACE), DDRecipeProvider.has(DDItems.WARDEN_CARAPACE)).save(output);
        DDRecipeProvider.copySmithingTemplate((RecipeOutput)output, DDItems.WARDEN_UPGRADE_SMITHING_TEMPLATE, (ItemLike)Blocks.SCULK);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, DDItems.SONOROUS_STAFF).define(Character.valueOf('B'), DDItems.SCULK_BONE).define(Character.valueOf('C'), DDItems.SOUL_CRYSTAL).define(Character.valueOf('H'), DDItems.HEART_OF_THE_DEEP).pattern(" CH").pattern(" BC").pattern("B  ").unlockedBy(DDRecipeProvider.getHasName(DDItems.SCULK_BONE), DDRecipeProvider.has(DDItems.SCULK_BONE)).unlockedBy(DDRecipeProvider.getHasName(DDItems.SOUL_CRYSTAL), DDRecipeProvider.has(DDItems.SOUL_CRYSTAL)).unlockedBy(DDRecipeProvider.getHasName(DDItems.HEART_OF_THE_DEEP), DDRecipeProvider.has(DDItems.HEART_OF_THE_DEEP)).save(output);
    }

    private void addCookingRecipes(RecipeOutput output) {
        this.smelting((ItemLike)DDBlocks.COBBLED_SCULK_STONE, RecipeCategory.BUILDING_BLOCKS, (ItemLike)DDBlocks.SCULK_STONE, 0.1f, output);
        this.smelting((ItemLike)DDBlocks.SCULK_STONE, RecipeCategory.BUILDING_BLOCKS, (ItemLike)DDBlocks.SMOOTH_SCULK_STONE, 0.1f, output);
        this.smelting((ItemLike)DDBlocks.COBBLED_GLOOMSLATE, RecipeCategory.BUILDING_BLOCKS, (ItemLike)DDBlocks.GLOOMSLATE, 0.1f, output);
        this.smelting((ItemLike)DDBlocks.GLOOMSLATE, RecipeCategory.BUILDING_BLOCKS, (ItemLike)DDBlocks.SMOOTH_GLOOMSLATE, 0.1f, output);
        this.smelting((ItemLike)DDBlocks.GLOOMY_CACTUS, RecipeCategory.MISC, (ItemLike)Items.ORANGE_DYE, 1.0f, output);
        this.smelting((ItemLike)DDItems.GRIME_BALL, RecipeCategory.MISC, (ItemLike)DDItems.GRIME_BRICK, 0.2f, output);
        this.oreSmelting((ItemLike)DDBlocks.SCULK_STONE_COAL_ORE, RecipeCategory.MISC, (ItemLike)Items.COAL, 0.1f, "coal", output);
        this.oreSmelting((ItemLike)DDBlocks.SCULK_STONE_IRON_ORE, RecipeCategory.MISC, (ItemLike)Items.IRON_INGOT, 0.7f, "iron_ingot", output);
        this.oreSmelting((ItemLike)DDBlocks.SCULK_STONE_COPPER_ORE, RecipeCategory.MISC, (ItemLike)Items.COPPER_INGOT, 0.7f, "copper_ingot", output);
        this.oreSmelting((ItemLike)DDBlocks.SCULK_STONE_GOLD_ORE, RecipeCategory.MISC, (ItemLike)Items.GOLD_INGOT, 1.0f, "gold_ingot", output);
        this.oreSmelting((ItemLike)DDBlocks.SCULK_STONE_REDSTONE_ORE, RecipeCategory.REDSTONE, (ItemLike)Items.REDSTONE, 0.7f, "redstone", output);
        this.oreSmelting((ItemLike)DDBlocks.SCULK_STONE_EMERALD_ORE, RecipeCategory.MISC, (ItemLike)Items.EMERALD, 1.0f, "emerald", output);
        this.oreSmelting((ItemLike)DDBlocks.SCULK_STONE_LAPIS_ORE, RecipeCategory.MISC, (ItemLike)Items.LAPIS_LAZULI, 0.2f, "lapis_lazuli", output);
        this.oreSmelting((ItemLike)DDBlocks.SCULK_STONE_DIAMOND_ORE, RecipeCategory.MISC, (ItemLike)Items.DIAMOND, 1.0f, "diamond", output);
        this.oreSmelting((ItemLike)DDBlocks.GLOOMSLATE_COAL_ORE, RecipeCategory.MISC, (ItemLike)Items.COAL, 0.1f, "coal", output);
        this.oreSmelting((ItemLike)DDBlocks.GLOOMSLATE_IRON_ORE, RecipeCategory.MISC, (ItemLike)Items.IRON_INGOT, 0.7f, "iron_ingot", output);
        this.oreSmelting((ItemLike)DDBlocks.GLOOMSLATE_COPPER_ORE, RecipeCategory.MISC, (ItemLike)Items.COPPER_INGOT, 0.7f, "copper_ingot", output);
        this.oreSmelting((ItemLike)DDBlocks.GLOOMSLATE_GOLD_ORE, RecipeCategory.MISC, (ItemLike)Items.GOLD_INGOT, 1.0f, "gold_ingot", output);
        this.oreSmelting((ItemLike)DDBlocks.GLOOMSLATE_REDSTONE_ORE, RecipeCategory.REDSTONE, (ItemLike)Items.REDSTONE, 0.7f, "redstone", output);
        this.oreSmelting((ItemLike)DDBlocks.GLOOMSLATE_EMERALD_ORE, RecipeCategory.MISC, (ItemLike)Items.EMERALD, 1.0f, "emerald", output);
        this.oreSmelting((ItemLike)DDBlocks.GLOOMSLATE_LAPIS_ORE, RecipeCategory.MISC, (ItemLike)Items.LAPIS_LAZULI, 0.2f, "lapis_lazuli", output);
        this.oreSmelting((ItemLike)DDBlocks.GLOOMSLATE_DIAMOND_ORE, RecipeCategory.MISC, (ItemLike)Items.DIAMOND, 1.0f, "diamond", output);
        this.oreBlasting((ItemLike)DDBlocks.SCULK_STONE_COAL_ORE, RecipeCategory.MISC, (ItemLike)Items.COAL, 0.1f, "coal", output);
        this.oreBlasting((ItemLike)DDBlocks.SCULK_STONE_IRON_ORE, RecipeCategory.MISC, (ItemLike)Items.IRON_INGOT, 0.7f, "iron_ingot", output);
        this.oreBlasting((ItemLike)DDBlocks.SCULK_STONE_COPPER_ORE, RecipeCategory.MISC, (ItemLike)Items.COPPER_INGOT, 0.7f, "copper_ingot", output);
        this.oreBlasting((ItemLike)DDBlocks.SCULK_STONE_GOLD_ORE, RecipeCategory.MISC, (ItemLike)Items.GOLD_INGOT, 1.0f, "gold_ingot", output);
        this.oreBlasting((ItemLike)DDBlocks.SCULK_STONE_REDSTONE_ORE, RecipeCategory.REDSTONE, (ItemLike)Items.REDSTONE, 0.7f, "redstone", output);
        this.oreBlasting((ItemLike)DDBlocks.SCULK_STONE_EMERALD_ORE, RecipeCategory.MISC, (ItemLike)Items.EMERALD, 1.0f, "emerald", output);
        this.oreBlasting((ItemLike)DDBlocks.SCULK_STONE_LAPIS_ORE, RecipeCategory.MISC, (ItemLike)Items.LAPIS_LAZULI, 0.2f, "lapis_lazuli", output);
        this.oreBlasting((ItemLike)DDBlocks.SCULK_STONE_DIAMOND_ORE, RecipeCategory.MISC, (ItemLike)Items.DIAMOND, 1.0f, "diamond", output);
        this.oreBlasting((ItemLike)DDBlocks.GLOOMSLATE_COAL_ORE, RecipeCategory.MISC, (ItemLike)Items.COAL, 0.1f, "coal", output);
        this.oreBlasting((ItemLike)DDBlocks.GLOOMSLATE_IRON_ORE, RecipeCategory.MISC, (ItemLike)Items.IRON_INGOT, 0.7f, "iron_ingot", output);
        this.oreBlasting((ItemLike)DDBlocks.GLOOMSLATE_COPPER_ORE, RecipeCategory.MISC, (ItemLike)Items.COPPER_INGOT, 0.7f, "copper_ingot", output);
        this.oreBlasting((ItemLike)DDBlocks.GLOOMSLATE_GOLD_ORE, RecipeCategory.MISC, (ItemLike)Items.GOLD_INGOT, 1.0f, "gold_ingot", output);
        this.oreBlasting((ItemLike)DDBlocks.GLOOMSLATE_REDSTONE_ORE, RecipeCategory.REDSTONE, (ItemLike)Items.REDSTONE, 0.7f, "redstone", output);
        this.oreBlasting((ItemLike)DDBlocks.GLOOMSLATE_EMERALD_ORE, RecipeCategory.MISC, (ItemLike)Items.EMERALD, 1.0f, "emerald", output);
        this.oreBlasting((ItemLike)DDBlocks.GLOOMSLATE_LAPIS_ORE, RecipeCategory.MISC, (ItemLike)Items.LAPIS_LAZULI, 0.2f, "lapis_lazuli", output);
        this.oreBlasting((ItemLike)DDBlocks.GLOOMSLATE_DIAMOND_ORE, RecipeCategory.MISC, (ItemLike)Items.DIAMOND, 1.0f, "diamond", output);
    }

    private void addStonecuttingRecipes(RecipeOutput output) {
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.SCULK_STONE, (ItemLike)DDBlocks.SCULK_STONE_STAIRS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.SCULK_STONE, (ItemLike)DDBlocks.SCULK_STONE_SLAB, 2);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.SCULK_STONE, (ItemLike)DDBlocks.SCULK_STONE_WALL);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_SCULK_STONE, (ItemLike)DDBlocks.COBBLED_SCULK_STONE_STAIRS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_SCULK_STONE, (ItemLike)DDBlocks.COBBLED_SCULK_STONE_SLAB, 2);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_SCULK_STONE, (ItemLike)DDBlocks.COBBLED_SCULK_STONE_WALL);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_SCULK_STONE, (ItemLike)DDBlocks.POLISHED_SCULK_STONE_STAIRS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_SCULK_STONE, (ItemLike)DDBlocks.POLISHED_SCULK_STONE_SLAB, 2);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_SCULK_STONE, (ItemLike)DDBlocks.POLISHED_SCULK_STONE_WALL);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_SCULK_STONE, (ItemLike)DDBlocks.POLISHED_SCULK_STONE);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.POLISHED_SCULK_STONE, (ItemLike)DDBlocks.POLISHED_SCULK_STONE_STAIRS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.POLISHED_SCULK_STONE, (ItemLike)DDBlocks.POLISHED_SCULK_STONE_SLAB, 2);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.POLISHED_SCULK_STONE, (ItemLike)DDBlocks.POLISHED_SCULK_STONE_WALL);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_SCULK_STONE, (ItemLike)DDBlocks.SCULK_STONE_BRICK_STAIRS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_SCULK_STONE, (ItemLike)DDBlocks.SCULK_STONE_BRICK_SLAB, 2);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_SCULK_STONE, (ItemLike)DDBlocks.SCULK_STONE_BRICK_WALL);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_SCULK_STONE, (ItemLike)DDBlocks.SCULK_STONE_BRICKS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.POLISHED_SCULK_STONE, (ItemLike)DDBlocks.SCULK_STONE_BRICK_STAIRS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.POLISHED_SCULK_STONE, (ItemLike)DDBlocks.SCULK_STONE_BRICK_SLAB, 2);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.POLISHED_SCULK_STONE, (ItemLike)DDBlocks.SCULK_STONE_BRICK_WALL);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.POLISHED_SCULK_STONE, (ItemLike)DDBlocks.SCULK_STONE_BRICKS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.SCULK_STONE_BRICKS, (ItemLike)DDBlocks.SCULK_STONE_BRICK_STAIRS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.SCULK_STONE_BRICKS, (ItemLike)DDBlocks.SCULK_STONE_BRICK_SLAB, 2);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.SCULK_STONE_BRICKS, (ItemLike)DDBlocks.SCULK_STONE_BRICK_WALL);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_SCULK_STONE, (ItemLike)DDBlocks.SCULK_STONE_TILE_STAIRS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_SCULK_STONE, (ItemLike)DDBlocks.SCULK_STONE_TILE_SLAB, 2);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_SCULK_STONE, (ItemLike)DDBlocks.SCULK_STONE_TILE_WALL);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_SCULK_STONE, (ItemLike)DDBlocks.SCULK_STONE_TILES);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.POLISHED_SCULK_STONE, (ItemLike)DDBlocks.SCULK_STONE_TILE_STAIRS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.POLISHED_SCULK_STONE, (ItemLike)DDBlocks.SCULK_STONE_TILE_SLAB, 2);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.POLISHED_SCULK_STONE, (ItemLike)DDBlocks.SCULK_STONE_TILE_WALL);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.POLISHED_SCULK_STONE, (ItemLike)DDBlocks.SCULK_STONE_TILES);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.SCULK_STONE_TILES, (ItemLike)DDBlocks.SCULK_STONE_TILE_STAIRS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.SCULK_STONE_TILES, (ItemLike)DDBlocks.SCULK_STONE_TILE_SLAB, 2);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.SCULK_STONE_TILES, (ItemLike)DDBlocks.SCULK_STONE_TILE_WALL);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.SMOOTH_SCULK_STONE, (ItemLike)DDBlocks.SMOOTH_SCULK_STONE_STAIRS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.SMOOTH_SCULK_STONE, (ItemLike)DDBlocks.SMOOTH_SCULK_STONE_SLAB, 2);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.SMOOTH_SCULK_STONE, (ItemLike)DDBlocks.SMOOTH_SCULK_STONE_WALL);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.SMOOTH_SCULK_STONE, (ItemLike)DDBlocks.CUT_SCULK_STONE_STAIRS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.SMOOTH_SCULK_STONE, (ItemLike)DDBlocks.CUT_SCULK_STONE_SLAB, 2);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.SMOOTH_SCULK_STONE, (ItemLike)DDBlocks.CUT_SCULK_STONE_WALL);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.CUT_SCULK_STONE, (ItemLike)DDBlocks.CUT_SCULK_STONE_STAIRS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.CUT_SCULK_STONE, (ItemLike)DDBlocks.CUT_SCULK_STONE_SLAB, 2);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.CUT_SCULK_STONE, (ItemLike)DDBlocks.CUT_SCULK_STONE_WALL);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_SCULK_STONE, (ItemLike)DDBlocks.CHISELED_SCULK_STONE);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.SCULK_STONE_BRICKS, (ItemLike)DDBlocks.CHISELED_SCULK_STONE);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.GLOOMSLATE, (ItemLike)DDBlocks.GLOOMSLATE_STAIRS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.GLOOMSLATE, (ItemLike)DDBlocks.GLOOMSLATE_SLAB, 2);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.GLOOMSLATE, (ItemLike)DDBlocks.GLOOMSLATE_WALL);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_GLOOMSLATE, (ItemLike)DDBlocks.COBBLED_GLOOMSLATE_STAIRS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_GLOOMSLATE, (ItemLike)DDBlocks.COBBLED_GLOOMSLATE_SLAB, 2);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_GLOOMSLATE, (ItemLike)DDBlocks.COBBLED_GLOOMSLATE_WALL);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_GLOOMSLATE, (ItemLike)DDBlocks.POLISHED_GLOOMSLATE_STAIRS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_GLOOMSLATE, (ItemLike)DDBlocks.POLISHED_GLOOMSLATE_SLAB, 2);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_GLOOMSLATE, (ItemLike)DDBlocks.POLISHED_GLOOMSLATE_WALL);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_GLOOMSLATE, (ItemLike)DDBlocks.POLISHED_GLOOMSLATE);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.POLISHED_GLOOMSLATE, (ItemLike)DDBlocks.POLISHED_GLOOMSLATE_STAIRS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.POLISHED_GLOOMSLATE, (ItemLike)DDBlocks.POLISHED_GLOOMSLATE_SLAB, 2);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.POLISHED_GLOOMSLATE, (ItemLike)DDBlocks.POLISHED_GLOOMSLATE_WALL);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_GLOOMSLATE, (ItemLike)DDBlocks.GLOOMSLATE_BRICK_STAIRS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_GLOOMSLATE, (ItemLike)DDBlocks.GLOOMSLATE_BRICK_SLAB, 2);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_GLOOMSLATE, (ItemLike)DDBlocks.GLOOMSLATE_BRICK_WALL);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_GLOOMSLATE, (ItemLike)DDBlocks.GLOOMSLATE_BRICKS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.POLISHED_GLOOMSLATE, (ItemLike)DDBlocks.GLOOMSLATE_BRICK_STAIRS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.POLISHED_GLOOMSLATE, (ItemLike)DDBlocks.GLOOMSLATE_BRICK_SLAB, 2);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.POLISHED_GLOOMSLATE, (ItemLike)DDBlocks.GLOOMSLATE_BRICK_WALL);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.POLISHED_GLOOMSLATE, (ItemLike)DDBlocks.GLOOMSLATE_BRICKS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.GLOOMSLATE_BRICKS, (ItemLike)DDBlocks.GLOOMSLATE_BRICK_STAIRS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.GLOOMSLATE_BRICKS, (ItemLike)DDBlocks.GLOOMSLATE_BRICK_SLAB, 2);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.GLOOMSLATE_BRICKS, (ItemLike)DDBlocks.GLOOMSLATE_BRICK_WALL);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_GLOOMSLATE, (ItemLike)DDBlocks.GLOOMSLATE_TILE_STAIRS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_GLOOMSLATE, (ItemLike)DDBlocks.GLOOMSLATE_TILE_SLAB, 2);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_GLOOMSLATE, (ItemLike)DDBlocks.GLOOMSLATE_TILE_WALL);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_GLOOMSLATE, (ItemLike)DDBlocks.GLOOMSLATE_TILES);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.POLISHED_GLOOMSLATE, (ItemLike)DDBlocks.GLOOMSLATE_TILE_STAIRS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.POLISHED_GLOOMSLATE, (ItemLike)DDBlocks.GLOOMSLATE_TILE_SLAB, 2);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.POLISHED_GLOOMSLATE, (ItemLike)DDBlocks.GLOOMSLATE_TILE_WALL);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.POLISHED_GLOOMSLATE, (ItemLike)DDBlocks.GLOOMSLATE_TILES);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.GLOOMSLATE_TILES, (ItemLike)DDBlocks.GLOOMSLATE_TILE_STAIRS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.GLOOMSLATE_TILES, (ItemLike)DDBlocks.GLOOMSLATE_TILE_SLAB, 2);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.GLOOMSLATE_TILES, (ItemLike)DDBlocks.GLOOMSLATE_TILE_WALL);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.SMOOTH_GLOOMSLATE, (ItemLike)DDBlocks.SMOOTH_GLOOMSLATE_STAIRS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.SMOOTH_GLOOMSLATE, (ItemLike)DDBlocks.SMOOTH_GLOOMSLATE_SLAB, 2);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.SMOOTH_GLOOMSLATE, (ItemLike)DDBlocks.SMOOTH_GLOOMSLATE_WALL);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.SMOOTH_GLOOMSLATE, (ItemLike)DDBlocks.CUT_GLOOMSLATE_STAIRS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.SMOOTH_GLOOMSLATE, (ItemLike)DDBlocks.CUT_GLOOMSLATE_SLAB, 2);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.SMOOTH_GLOOMSLATE, (ItemLike)DDBlocks.CUT_GLOOMSLATE_WALL);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.CUT_GLOOMSLATE, (ItemLike)DDBlocks.CUT_GLOOMSLATE_STAIRS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.CUT_GLOOMSLATE, (ItemLike)DDBlocks.CUT_GLOOMSLATE_SLAB, 2);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.CUT_GLOOMSLATE, (ItemLike)DDBlocks.CUT_GLOOMSLATE_WALL);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.COBBLED_GLOOMSLATE, (ItemLike)DDBlocks.CHISELED_GLOOMSLATE);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.GLOOMSLATE_BRICKS, (ItemLike)DDBlocks.CHISELED_GLOOMSLATE);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.SCULK_GRIME_BRICKS, (ItemLike)DDBlocks.SCULK_GRIME_BRICK_STAIRS);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.SCULK_GRIME_BRICKS, (ItemLike)DDBlocks.SCULK_GRIME_BRICK_SLAB, 2);
        this.stonecuttingRecipe(output, (ItemLike)DDBlocks.SCULK_GRIME_BRICKS, (ItemLike)DDBlocks.SCULK_GRIME_BRICK_WALL);
    }

    private void addSmithingRecipes(RecipeOutput output) {
        this.resonariumSmithing(output, (ItemLike)Items.IRON_SHOVEL, RecipeCategory.TOOLS, (Item)DDItems.RESONARIUM_SHOVEL.get());
        this.resonariumSmithing(output, (ItemLike)Items.IRON_PICKAXE, RecipeCategory.TOOLS, (Item)DDItems.RESONARIUM_PICKAXE.get());
        this.resonariumSmithing(output, (ItemLike)Items.IRON_AXE, RecipeCategory.TOOLS, (Item)DDItems.RESONARIUM_AXE.get());
        this.resonariumSmithing(output, (ItemLike)Items.IRON_HOE, RecipeCategory.TOOLS, (Item)DDItems.RESONARIUM_HOE.get());
        this.resonariumSmithing(output, (ItemLike)Items.IRON_SWORD, RecipeCategory.COMBAT, (Item)DDItems.RESONARIUM_SWORD.get());
        this.resonariumSmithing(output, (ItemLike)Items.IRON_HELMET, RecipeCategory.COMBAT, (Item)DDItems.RESONARIUM_HELMET.get());
        this.resonariumSmithing(output, (ItemLike)Items.IRON_CHESTPLATE, RecipeCategory.COMBAT, (Item)DDItems.RESONARIUM_CHESTPLATE.get());
        this.resonariumSmithing(output, (ItemLike)Items.IRON_LEGGINGS, RecipeCategory.COMBAT, (Item)DDItems.RESONARIUM_LEGGINGS.get());
        this.resonariumSmithing(output, (ItemLike)Items.IRON_BOOTS, RecipeCategory.COMBAT, (Item)DDItems.RESONARIUM_BOOTS.get());
        this.wardenSmithing(output, (ItemLike)Items.NETHERITE_SHOVEL, RecipeCategory.TOOLS, (Item)DDItems.WARDEN_SHOVEL.get());
        this.wardenSmithing(output, (ItemLike)Items.NETHERITE_PICKAXE, RecipeCategory.TOOLS, (Item)DDItems.WARDEN_PICKAXE.get());
        this.wardenSmithing(output, (ItemLike)Items.NETHERITE_AXE, RecipeCategory.TOOLS, (Item)DDItems.WARDEN_AXE.get());
        this.wardenSmithing(output, (ItemLike)Items.NETHERITE_HOE, RecipeCategory.TOOLS, (Item)DDItems.WARDEN_HOE.get());
        this.wardenSmithing(output, (ItemLike)Items.NETHERITE_SWORD, RecipeCategory.COMBAT, (Item)DDItems.WARDEN_SWORD.get());
        this.wardenSmithing(output, (ItemLike)Items.NETHERITE_HELMET, RecipeCategory.COMBAT, (Item)DDItems.WARDEN_HELMET.get());
        this.wardenSmithing(output, (ItemLike)Items.NETHERITE_CHESTPLATE, RecipeCategory.COMBAT, (Item)DDItems.WARDEN_CHESTPLATE.get());
        this.wardenSmithing(output, (ItemLike)Items.NETHERITE_LEGGINGS, RecipeCategory.COMBAT, (Item)DDItems.WARDEN_LEGGINGS.get());
        this.wardenSmithing(output, (ItemLike)Items.NETHERITE_BOOTS, RecipeCategory.COMBAT, (Item)DDItems.WARDEN_BOOTS.get());
    }

    private void resonariumSmithing(RecipeOutput output, ItemLike ingredient, RecipeCategory category, Item result) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of(), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{DDItems.RESONARIUM_PLATE}), (RecipeCategory)category, (Item)result).unlocks(DDRecipeProvider.getHasName(DDItems.RESONARIUM_PLATE), DDRecipeProvider.has(DDItems.RESONARIUM_PLATE)).save(output, DeeperDarker.rl(DDRecipeProvider.getItemName((ItemLike)result) + "_smithing"));
    }

    private void wardenSmithing(RecipeOutput output, ItemLike ingredient, RecipeCategory category, Item result) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{DDItems.WARDEN_UPGRADE_SMITHING_TEMPLATE}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{DDItems.REINFORCED_ECHO_SHARD}), (RecipeCategory)category, (Item)result).unlocks(DDRecipeProvider.getHasName(DDItems.REINFORCED_ECHO_SHARD), DDRecipeProvider.has(DDItems.REINFORCED_ECHO_SHARD)).save(output, DeeperDarker.rl(DDRecipeProvider.getItemName((ItemLike)result) + "_smithing"));
    }

    private void woodenRecipes(RecipeOutput output, TagKey<Item> logs, DeferredBlock<? extends Block> strippedLog, DeferredBlock<Block> planks, DeferredBlock<StairBlock> stairs, DeferredBlock<SlabBlock> slabs, DeferredBlock<FenceBlock> fence, DeferredBlock<FenceGateBlock> fenceGate, DeferredBlock<DoorBlock> door, DeferredBlock<TrapDoorBlock> trapDoor, DeferredBlock<PressurePlateBlock> pressurePlate, DeferredBlock<ButtonBlock> button, DeferredItem<Item> sign, DeferredItem<Item> hangingSign, DeferredItem<Item> boat, DeferredItem<Item> chestBoat) {
        DDRecipeProvider.planksFromLogs((RecipeOutput)output, planks, logs, (int)4);
        DDRecipeProvider.stairBuilder(stairs, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{planks})).unlockedBy("has_planks", DDRecipeProvider.has(planks)).save(output);
        DDRecipeProvider.slab((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, slabs, planks);
        DDRecipeProvider.fenceBuilder(fence, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{planks})).unlockedBy("has_planks", DDRecipeProvider.has(planks)).save(output);
        DDRecipeProvider.fenceGateBuilder(fenceGate, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{planks})).unlockedBy("has_planks", DDRecipeProvider.has(planks)).save(output);
        DDRecipeProvider.doorBuilder(door, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{planks})).unlockedBy("has_planks", DDRecipeProvider.has(planks)).save(output);
        DDRecipeProvider.trapdoorBuilder(trapDoor, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{planks})).unlockedBy("has_planks", DDRecipeProvider.has(planks)).save(output);
        DDRecipeProvider.pressurePlate((RecipeOutput)output, pressurePlate, planks);
        DDRecipeProvider.buttonBuilder(button, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{planks})).unlockedBy("has_planks", DDRecipeProvider.has(planks)).save(output);
        DDRecipeProvider.signBuilder(sign, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{planks})).unlockedBy("has_planks", DDRecipeProvider.has(planks)).save(output);
        DDRecipeProvider.hangingSign((RecipeOutput)output, hangingSign, strippedLog);
        DDRecipeProvider.woodenBoat((RecipeOutput)output, boat, planks);
        DDRecipeProvider.chestBoat((RecipeOutput)output, chestBoat, boat);
    }

    private void smelting(ItemLike ingredient, RecipeCategory category, ItemLike result, float experience, RecipeOutput output) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), (RecipeCategory)category, (ItemLike)result, (float)experience, (int)200).unlockedBy(DDRecipeProvider.getHasName((ItemLike)ingredient), DDRecipeProvider.has((ItemLike)ingredient)).save(output);
    }

    private void oreSmelting(ItemLike ingredient, RecipeCategory category, ItemLike result, float experience, String group, RecipeOutput output) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), (RecipeCategory)category, (ItemLike)result, (float)experience, (int)200).group(group).unlockedBy(DDRecipeProvider.getHasName((ItemLike)ingredient), DDRecipeProvider.has((ItemLike)ingredient)).save(output, DeeperDarker.rl(DDRecipeProvider.getSmeltingRecipeName((ItemLike)result) + "_" + DDRecipeProvider.getItemName((ItemLike)ingredient)));
    }

    private void oreBlasting(ItemLike ingredient, RecipeCategory category, ItemLike result, float experience, String group, RecipeOutput output) {
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), (RecipeCategory)category, (ItemLike)result, (float)experience, (int)100).group(group).unlockedBy(DDRecipeProvider.getHasName((ItemLike)ingredient), DDRecipeProvider.has((ItemLike)ingredient)).save(output, DeeperDarker.rl(DDRecipeProvider.getBlastingRecipeName((ItemLike)result) + "_" + DDRecipeProvider.getItemName((ItemLike)ingredient)));
    }

    private void stonecuttingRecipe(RecipeOutput output, ItemLike ingredient, ItemLike result) {
        this.stonecuttingRecipe(output, ingredient, result, 1);
    }

    private void stonecuttingRecipe(RecipeOutput output, ItemLike ingredient, ItemLike result, int count) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).unlockedBy(DDRecipeProvider.getHasName((ItemLike)ingredient), DDRecipeProvider.has((ItemLike)ingredient)).save(output, ResourceLocation.fromNamespaceAndPath((String)"deeperdarker", (String)(DDRecipeProvider.getConversionRecipeName((ItemLike)result, (ItemLike)ingredient) + "_stonecutting")));
    }
}

