/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.mixin;

import com.kyanite.deeperdarker.util.DDTags;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Painting.class})
public abstract class PaintingMixin
extends HangingEntity {
    protected PaintingMixin(EntityType<? extends HangingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract Holder<PaintingVariant> getVariant();

    @Shadow
    public abstract void setVariant(Holder<PaintingVariant> var1);

    @Inject(method={"dropItem"}, at={@At(value="HEAD")}, cancellable=true)
    public void dropItem(Entity entity, CallbackInfo cir) {
        if (this.getVariant().is(DDTags.Misc.ANCIENT_PAINTING) && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            this.playSound(SoundEvents.PAINTING_BREAK, 1.0f, 1.0f);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (player.getAbilities().instabuild) {
                    return;
                }
            }
            CompoundTag tag = new CompoundTag();
            Painting.VARIANT_CODEC.encodeStart((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), this.getVariant()).ifSuccess(tag1 -> tag.merge((CompoundTag)tag1));
            tag.putString("id", "minecraft:painting");
            ItemEntity itemEntity = this.spawnAtLocation((ItemLike)Items.PAINTING);
            itemEntity.getItem().set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
            cir.cancel();
        }
    }

    @Inject(method={"getPickResult"}, at={@At(value="RETURN")}, cancellable=true)
    public void getPickResult(CallbackInfoReturnable<ItemStack> cir) {
        if (this.getVariant().is(DDTags.Misc.ANCIENT_PAINTING)) {
            CompoundTag tag = ((CustomData)((ItemStack)cir.getReturnValue()).getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY)).copyTag();
            Painting.VARIANT_CODEC.encodeStart((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), this.getVariant()).ifSuccess(tag1 -> tag.merge((CompoundTag)tag1));
            tag.putString("id", "minecraft:painting");
            ItemStack stack = new ItemStack((ItemLike)Items.PAINTING);
            stack.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
            cir.setReturnValue((Object)stack);
        }
    }
}

