/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.block;

import alabaster.crabbersdelight.common.registry.CDDamageSources;
import alabaster.crabbersdelight.common.registry.CDModItems;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CoconutBlock
extends FallingBlock {
    public static final BooleanProperty HANGING = BooleanProperty.create((String)"hanging");
    private static VoxelShape SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
    public static final MapCodec<CoconutBlock> CODEC = CoconutBlock.simpleCodec(CoconutBlock::new);

    public CoconutBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)HANGING, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends FallingBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HANGING});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)HANGING)).booleanValue()) {
            return Block.box((double)3.0, (double)5.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0);
        }
        return Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (facing == Direction.UP) {
            boolean hanging;
            boolean bl = hanging = !neighborState.isAir();
            if (!hanging) {
                level.scheduleTick(pos, (Block)this, 1);
            }
            return (BlockState)state.setValue((Property)HANGING, (Comparable)Boolean.valueOf(hanging));
        }
        return super.updateShape(state, facing, neighborState, level, pos, neighborPos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos above;
        Level level = context.getLevel();
        BlockState aboveState = level.getBlockState(above = context.getClickedPos().above());
        boolean hanging = !aboveState.isAir();
        return (BlockState)this.defaultBlockState().setValue((Property)HANGING, (Comparable)Boolean.valueOf(hanging));
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean hanging = (Boolean)state.getValue((Property)HANGING);
        if (!hanging) {
            super.tick(state, level, pos, random);
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
    }

    public void onLand(Level level, BlockPos pos, BlockState state, BlockState replaceState, FallingBlockEntity fallingEntity) {
        super.onLand(level, pos, state, replaceState, fallingEntity);
        if (!level.isClientSide && fallingEntity != null) {
            boolean hitPlayer = false;
            for (Entity entity : level.getEntities(null, SHAPE.bounds().move(pos))) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)entity;
                living.hurt(CDDamageSources.getSimpleDamageSource(level, CDDamageSources.FALLING_COCONUT), 2.0f);
                if (!(entity instanceof Player)) continue;
                Player player = (Player)entity;
                level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.GOAT_HORN_BREAK, SoundSource.PLAYERS, 0.7f, 0.5f);
                player.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200, 0));
                player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 2));
                ItemStack headSlot = player.getItemBySlot(EquipmentSlot.HEAD);
                if (headSlot.isEmpty()) {
                    ItemStack coconutHelmet = new ItemStack((ItemLike)CDModItems.COCONUT_HELMET.get());
                    player.setItemSlot(EquipmentSlot.HEAD, coconutHelmet);
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARMOR_EQUIP_LEATHER, SoundSource.PLAYERS, 1.0f, 1.0f);
                    level.destroyBlock(pos, false);
                }
                hitPlayer = true;
            }
            if (hitPlayer) {
                level.destroyBlock(pos, true);
            }
        }
    }

    public void onProjectileHit(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        super.onProjectileHit(level, state, hit, projectile);
        if (!level.isClientSide) {
            BlockPos pos = hit.getBlockPos();
            if (((Boolean)state.getValue((Property)HANGING)).booleanValue()) {
                level.setBlock(pos, (BlockState)state.setValue((Property)HANGING, (Comparable)Boolean.valueOf(false)), 3);
                level.scheduleTick(pos, (Block)this, 1);
            }
        }
    }
}

