/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.block.entity;

import alabaster.crabbersdelight.CrabbersDelight;
import alabaster.crabbersdelight.common.Config;
import alabaster.crabbersdelight.common.block.container.CrabTrapMenu;
import alabaster.crabbersdelight.common.block.entity.inventory.CrabTrapItemHandler;
import alabaster.crabbersdelight.common.registry.CDModBlockEntity;
import alabaster.crabbersdelight.common.tags.CDModTags;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="crabbersdelight", bus=EventBusSubscriber.Bus.MOD)
public class CrabTrapBlockEntity
extends BlockEntity
implements MenuProvider,
Nameable {
    public static final Component CRAB_TRAP_NAME = Component.translatable((String)"block.crabbersdelight.crab_trap");
    private final CrabTrapItemHandler handler = new CrabTrapItemHandler(){

        protected void onContentsChanged(int slot) {
            CrabTrapBlockEntity.this.setChanged();
        }
    };
    private final IItemHandler input = new RangedWrapper((IItemHandlerModifiable)this.handler, 0, 1);
    private final IItemHandler output = new RangedWrapper((IItemHandlerModifiable)this.handler, 1, 10);
    private int tickCounter = 0;

    public CrabTrapBlockEntity(BlockPos pos, BlockState state) {
        super(CDModBlockEntity.CRAB_TRAP.get(), pos, state);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("handler", (Tag)this.handler.serializeNBT(registries));
        tag.putInt("tickCounter", this.tickCounter);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.handler.deserializeNBT(registries, tag.getCompound("handler"));
        this.tickCounter = tag.getInt("tickCounter");
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    private CompoundTag saveItems(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.saveAdditional(compound, pRegistries);
        compound.put("handler", (Tag)this.handler.serializeNBT(pRegistries));
        return compound;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveItems(new CompoundTag(), registries);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(tag, lookupProvider);
    }

    public static Pair<Integer, Integer> getMinMax() {
        return Pair.of((Object)((Integer)Config.MIN_TICKS.get()), (Object)((Integer)Config.MAX_TICKS.get()));
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CrabTrapBlockEntity blockEntity) {
        RandomSource random = level.getRandom();
        if ((Integer)CrabTrapBlockEntity.getMinMax().getSecond() > (Integer)CrabTrapBlockEntity.getMinMax().getFirst()) {
            if (blockEntity.tickCounter >= random.nextIntBetweenInclusive(((Integer)CrabTrapBlockEntity.getMinMax().getFirst()).intValue(), ((Integer)CrabTrapBlockEntity.getMinMax().getSecond()).intValue())) {
                blockEntity.tickCounter = 0;
                if (CrabTrapBlockEntity.isSurroundedByWater(level, pos) && CrabTrapBlockEntity.isValidFishingLocation(level, pos)) {
                    LootParams lootparams = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.ORIGIN, (Object)new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withParameter(LootContextParams.BLOCK_ENTITY, (Object)blockEntity).create(LootContextParamSets.FISHING);
                    ItemStack itemInBaitSlot = blockEntity.handler.getStackInSlot(0);
                    if (itemInBaitSlot.is(CDModTags.CRAB_TRAP_BAIT)) {
                        ResourceLocation registryName = BuiltInRegistries.ITEM.getKey((Object)itemInBaitSlot.getItem());
                        ResourceLocation lootTableLocation = CrabbersDelight.modPrefix("gameplay/crab_trap_loot/" + registryName.getPath());
                        LootTable loottable = level.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)lootTableLocation));
                        ObjectArrayList list = loottable.getRandomItems(lootparams);
                        blockEntity.handler.addItemsAndShrinkBait(level, pos, (List<ItemStack>)list, itemInBaitSlot, random);
                    }
                }
            } else {
                if (CrabTrapBlockEntity.isWaterBiome(level, pos)) {
                    ++blockEntity.tickCounter;
                }
                ++blockEntity.tickCounter;
            }
        } else {
            CrabbersDelight.LOGGER.error("Error: Minimum value is higher than maximum value!");
        }
    }

    private static boolean isValidFishingLocation(Level level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!level.getBlockState(pos).getFluidState().is(FluidTags.WATER) || !level.getFluidState(pos.relative(direction)).is(FluidTags.WATER)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSurroundedByWater(Level level, BlockPos pos) {
        if (((Boolean)Config.REQUIRE_SURROUNDING_WATER.get()).booleanValue()) {
            for (BlockPos nearbyPos : BlockPos.betweenClosed((BlockPos)pos.offset(-1, 0, -1), (BlockPos)pos.offset(1, 0, 1))) {
                if (level.getFluidState(nearbyPos).is(FluidTags.WATER)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    private static boolean isWaterBiome(Level level, BlockPos pos) {
        return level.getBiome(pos).is(Tags.Biomes.IS_AQUATIC);
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, CDModBlockEntity.CRAB_TRAP.get(), (be, context) -> {
            if (context == Direction.UP) {
                return be.input;
            }
            return be.output;
        });
    }

    public CrabTrapItemHandler getInventory() {
        return this.handler;
    }

    public Component getName() {
        return CRAB_TRAP_NAME;
    }

    public Component getDisplayName() {
        return CRAB_TRAP_NAME;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInv, Player player) {
        return new CrabTrapMenu(id, playerInv, this.handler, ContainerLevelAccess.NULL);
    }
}

