/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.block.entity.inventory;

import alabaster.crabbersdelight.common.tags.CDModTags;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class CrabTrapItemHandler
extends ItemStackHandler {
    public CrabTrapItemHandler() {
        super(10);
    }

    public void addItemsAndShrinkBait(Level level, BlockPos pos, List<ItemStack> lootList, ItemStack baitItem, RandomSource random) {
        boolean insertedAny = false;
        for (ItemStack lootStack : lootList) {
            if (lootStack.isEmpty()) continue;
            for (int slot = 0; slot < this.getSlots(); ++slot) {
                ItemStack remainder = this.insertItem(slot, lootStack, false);
                if (remainder.getCount() != lootStack.getCount()) {
                    insertedAny = true;
                }
                if ((lootStack = remainder).isEmpty()) break;
            }
            if (!lootStack.isEmpty()) continue;
            if (baitItem.is(CDModTags.CRAB_TRAP_BAIT) && !baitItem.is(CDModTags.CHUMS)) {
                baitItem.shrink(1);
                continue;
            }
            if (!baitItem.is(CDModTags.CHUMS)) continue;
            Item ext = baitItem.getItem();
            int curr = ext.getDamage(baitItem);
            int max = ext.getMaxDamage(baitItem);
            ext.setDamage(baitItem, curr + 1);
            if (curr + 1 < max) continue;
            baitItem.shrink(1);
            this.insertItem(0, new ItemStack((ItemLike)Items.BUCKET), false);
        }
        if (insertedAny) {
            level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.FISH_SWIM, SoundSource.BLOCKS, 0.5f, 1.0f);
        }
    }

    protected int getStackLimit(int slot, ItemStack stack) {
        return slot != 0 ? 8 : stack.getMaxStackSize();
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        if (slot == 0) {
            return stack.is(CDModTags.CRAB_TRAP_BAIT);
        }
        return true;
    }

    public NonNullList<ItemStack> getItems() {
        return this.stacks;
    }
}

