/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.worldgen;

import alabaster.crabbersdelight.common.registry.CDModBlocks;
import alabaster.crabbersdelight.common.worldgen.CDConfiguredFeatures;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class CDPlacedFeatures {
    public static final ResourceKey<PlacedFeature> PALM_PLACED_KEY = CDPlacedFeatures.registerKey("palm_placed");
    public static final ResourceKey<PlacedFeature> SEASHELLS_PLACED_KEY = CDPlacedFeatures.registerKey("seashells_placed");
    public static final ResourceKey<PlacedFeature> SEASHELLS_PLACED_KEY_UNDERWATER = CDPlacedFeatures.registerKey("seashells_placed_underwater");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        CDPlacedFeatures.register(context, PALM_PLACED_KEY, configuredFeatures.getOrThrow(CDConfiguredFeatures.PALM_KEY), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)2, (float)0.1f, (int)1), (Block)CDModBlocks.PALM_SAPLING.get()));
        CDPlacedFeatures.register(context, SEASHELLS_PLACED_KEY, configuredFeatures.getOrThrow(CDConfiguredFeatures.SEASHELLS_KEY), List.of(RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)Direction.DOWN.getNormal(), (Block[])new Block[]{Blocks.SAND})), BiomeFilter.biome()));
        CDPlacedFeatures.register(context, SEASHELLS_PLACED_KEY_UNDERWATER, configuredFeatures.getOrThrow(CDConfiguredFeatures.SEASHELLS_KEY_UNDERWATER), List.of(RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)Direction.DOWN.getNormal(), (Block[])new Block[]{Blocks.SAND})), BiomeFilter.biome()));
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

