/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.worldgen.tree;

import alabaster.crabbersdelight.common.block.CoconutBlock;
import alabaster.crabbersdelight.common.registry.CDModBlocks;
import alabaster.crabbersdelight.common.registry.CDTrunkPlacerTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class PalmTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<PalmTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> PalmTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).and((App)IntProvider.CODEC.fieldOf("bend_length").forGetter(p -> p.bendLength)).apply((Applicative)instance, PalmTrunkPlacer::new));
    private final IntProvider bendLength;

    public PalmTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight, IntProvider bendLength) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.bendLength = bendLength;
    }

    protected TrunkPlacerType<?> type() {
        return CDTrunkPlacerTypes.PALM.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int height, BlockPos pos, TreeConfiguration config) {
        int dx = random.nextBoolean() ? 1 : -1;
        int dz = random.nextBoolean() ? 1 : -1;
        int bend = this.bendLength.sample(random);
        BlockPos.MutableBlockPos cursor = pos.mutable();
        for (int y = 0; y < height; ++y) {
            if (y > height / 3 && bend > 0 && random.nextInt(3) == 0) {
                cursor.move(dx, 0, dz);
                --bend;
            }
            this.placeLog(level, blockSetter, random, (BlockPos)cursor, config);
            cursor.move(0, 1, 0);
        }
        int CHANCE = 20;
        int RADIUS = 3;
        int MAX_COCONUTS = 3;
        int MAX_ATTEMPTS = 10;
        int MAX_DESCEND = 6;
        if (random.nextInt(20) == 0) {
            int coconutCount = 1 + random.nextInt(3);
            block1: for (int i = 0; i < coconutCount; ++i) {
                for (int attempt = 0; attempt < 10; ++attempt) {
                    int rx = pos.getX() + random.nextInt(7) - 3;
                    int rz = pos.getZ() + random.nextInt(7) - 3;
                    BlockPos candidate = new BlockPos(rx, pos.getY(), rz);
                    boolean placed = false;
                    for (int dy = 0; dy >= -6; --dy) {
                        BlockPos target = candidate.offset(0, dy, 0);
                        if (!level.isStateAtPosition(target, BlockBehaviour.BlockStateBase::isAir) || level.isStateAtPosition(target.below(), BlockBehaviour.BlockStateBase::isAir)) continue;
                        blockSetter.accept(target, (BlockState)CDModBlocks.COCONUT.get().defaultBlockState().setValue((Property)CoconutBlock.HANGING, (Comparable)Boolean.valueOf(false)));
                        placed = true;
                        break;
                    }
                    if (placed) continue block1;
                }
            }
        }
        return List.of(new FoliagePlacer.FoliageAttachment((BlockPos)cursor, 0, false));
    }
}

