/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.integration.jei;

import alabaster.crabbersdelight.CrabbersDelight;
import alabaster.crabbersdelight.common.registry.CDModItems;
import alabaster.crabbersdelight.common.tags.CDModTags;
import alabaster.crabbersdelight.integration.jei.CrabTrapRecipeWrapper;
import alabaster.crabbersdelight.integration.jei.category.CrabTrapCategory;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation PLUGIN_ID = CrabbersDelight.modPrefix("jei_plugin");
    public static final RecipeType<CrabTrapRecipeWrapper> CRAB_TRAP_RECIPE = RecipeType.create((String)"crabbersdelight", (String)"crab_trap_loot", CrabTrapRecipeWrapper.class);

    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new CrabTrapCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(CRAB_TRAP_RECIPE, this.addWrappers());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)CDModItems.CRAB_TRAP.get()), new RecipeType[]{CRAB_TRAP_RECIPE});
    }

    public List<CrabTrapRecipeWrapper> addWrappers() {
        ArrayList<CrabTrapRecipeWrapper> list = new ArrayList<CrabTrapRecipeWrapper>();
        for (ItemStack item : BuiltInRegistries.ITEM.stream().map(ItemStack::new).toList()) {
            ResourceLocation registryName;
            TagKey outputTag;
            if (!item.is(CDModTags.CRAB_TRAP_BAIT) || !BuiltInRegistries.ITEM.getTag(outputTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)CrabbersDelight.modPrefix("jei_display_results/" + (registryName = BuiltInRegistries.ITEM.getKey((Object)item.getItem())).getNamespace() + "/" + registryName.getPath()))).isPresent()) continue;
            list.add(new CrabTrapRecipeWrapper(item, Ingredient.of((TagKey)outputTag)));
        }
        return list;
    }
}

