/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.task;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.client.export.ImageExporter;
import io.github.mortuusars.exposure.client.image.modifier.ImageEffect;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.data.export.ExportLook;
import io.github.mortuusars.exposure.data.export.ExportSize;
import io.github.mortuusars.exposure.util.cycles.task.Result;
import io.github.mortuusars.exposure.util.cycles.task.Task;
import io.github.mortuusars.exposure.world.level.storage.ExposureData;
import io.github.mortuusars.exposure.world.level.storage.RequestedPalettedExposure;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ExportExposuresTask
extends Task<Result<Boolean>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private static ExportExposuresTask currentTask;
    protected final List<String> ids;
    protected final ExportSize size;
    protected final ExportLook look;
    @Nullable
    protected CompletableFuture<Result<Boolean>> future;
    protected boolean stop;

    public ExportExposuresTask(List<String> ids, ExportSize size, ExportLook look) {
        this.ids = ids;
        this.size = size;
        this.look = look;
    }

    public static boolean isRunning() {
        return currentTask != null;
    }

    public static boolean start(List<String> ids, ExportSize size, ExportLook look) {
        if (ExportExposuresTask.isRunning()) {
            Minecrft.player().displayClientMessage((Component)Component.translatable((String)"task.exposure.export.already_running"), false);
            return false;
        }
        ExposureClient.cycles().addParallelTask(new ExportExposuresTask(ids, size, look));
        return true;
    }

    public static boolean stopCurrentTask() {
        if (currentTask != null) {
            ExportExposuresTask.currentTask.stop = true;
            return true;
        }
        return false;
    }

    @Override
    public CompletableFuture<Result<Boolean>> execute() {
        currentTask = this;
        if (this.future == null) {
            this.future = CompletableFuture.supplyAsync(() -> {
                try {
                    Result<Boolean> result = this.export();
                    return result;
                }
                finally {
                    currentTask = null;
                }
            });
            this.setStarted();
        }
        return this.future;
    }

    protected Result<Boolean> export() {
        int total = this.ids.size();
        AtomicInteger exported = new AtomicInteger();
        this.print(Component.translatable((String)"task.exposure.export.started", (Object[])new Object[]{total}));
        for (String id : this.ids) {
            if (this.stop) {
                this.print(Component.translatable((String)"task.exposure.export.stopped"));
                return Result.success(false);
            }
            ExposureData exposure = null;
            for (int attempt = 0; attempt < 50; ++attempt) {
                this.updateStatus(Component.translatable((String)"task.exposure.export.status.requesting", (Object[])new Object[]{id, exported, total}));
                RequestedPalettedExposure request = ExposureClient.exposureStore().getOrRequest(id);
                if (request.getData().isPresent()) {
                    exposure = request.getData().get();
                    break;
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (exposure == null) {
                this.print(Component.translatable((String)"task.exposure.export.error.not_received", (Object[])new Object[]{id}));
                continue;
            }
            this.updateStatus(Component.translatable((String)"task.exposure.export.status.exporting", (Object[])new Object[]{id, exported, total}));
            try {
                String fileName = id + this.look.getIdSuffix();
                new ImageExporter(exposure, fileName).modify(ImageEffect.chain(this.look.getModifier(), ImageEffect.Resize.multiplier(this.size.getMultiplier()))).toExposuresFolder().organizeByWorld((Boolean)Config.Client.EXPORT_ORGANIZE_BY_WORLD.get()).setCreationDate(exposure.getTag().unixTimestamp()).onExport(file -> {
                    exported.getAndIncrement();
                    this.print(Component.translatable((String)"task.exposure.export.exported").append("'" + fileName + "'").withStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Open"))).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getAbsolutePath()))));
                }).export();
            }
            catch (Exception e) {
                this.print(Component.translatable((String)"task.exposure.export.error", (Object[])new Object[]{id, e.getMessage()}));
                LOGGER.error("Failed to export exposure '{}': ", (Object)id, (Object)e);
            }
        }
        if (exported.get() > 0) {
            this.print(Component.translatable((String)"task.exposure.export.result", (Object[])new Object[]{total}));
        } else {
            this.print(Component.translatable((String)"task.exposure.export.none_exported"));
        }
        this.updateStatus(Component.empty());
        return Result.success(true);
    }

    protected void print(MutableComponent message) {
        Minecrft.execute(() -> Minecrft.player().displayClientMessage((Component)message, false));
    }

    protected void updateStatus(MutableComponent status) {
        Minecrft.execute(() -> Minecrft.player().displayClientMessage((Component)status, true));
    }
}

