/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.commands.argument;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.mortuusars.exposure.data.export.ExportLook;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class ExposureLookArgument
implements ArgumentType<ExportLook> {
    public ExportLook parse(StringReader reader) throws CommandSyntaxException {
        String string = reader.readString();
        @Nullable ExportLook look = ExportLook.byName(string);
        if (look == null) {
            throw new SimpleCommandExceptionType((Message)Component.translatable((String)"argument.enum.invalid", (Object[])new Object[]{string})).create();
        }
        return look;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(Arrays.stream(ExportLook.values()).filter(l -> l != ExportLook.REGULAR).map(ExportLook::getSerializedName), (SuggestionsBuilder)builder);
    }

    public static ExportLook getLook(CommandContext<?> context, String name) {
        return (ExportLook)((Object)context.getArgument(name, ExportLook.class));
    }
}

