/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.mixin;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.world.inventory.ItemRenameMenu;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.game.ServerboundRenameItemPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class ServerGamePacketListenerMixin {
    @Shadow
    public ServerPlayer player;

    @Inject(method={"handleRenameItem(Lnet/minecraft/network/protocol/game/ServerboundRenameItemPacket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleRename(ServerboundRenameItemPacket packet, CallbackInfo ci) {
        PacketUtils.ensureRunningOnSameThread((Packet)packet, (PacketListener)((ServerGamePacketListenerImpl)this), (ServerLevel)this.player.serverLevel());
        AbstractContainerMenu abstractContainerMenu = this.player.containerMenu;
        if (abstractContainerMenu instanceof ItemRenameMenu) {
            ItemRenameMenu itemRenameMenu = (ItemRenameMenu)abstractContainerMenu;
            if (!itemRenameMenu.stillValid((Player)this.player)) {
                Exposure.LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)itemRenameMenu);
            } else {
                itemRenameMenu.setItemName(packet.getName());
            }
            ci.cancel();
        }
    }
}

