/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.mixin.client;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.client.camera.CameraClient;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import io.github.mortuusars.exposure.world.item.StackedPhotographsItem;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemInHandRenderer.class})
public abstract class ItemInHandRendererMixin {
    @Shadow
    private ItemStack mainHandItem;
    @Shadow
    private ItemStack offHandItem;

    @Shadow
    protected abstract void renderPlayerArm(PoseStack var1, MultiBufferSource var2, int var3, float var4, float var5, HumanoidArm var6);

    @Shadow
    protected abstract float calculateMapTilt(float var1);

    @Shadow
    protected abstract void renderMapHand(PoseStack var1, MultiBufferSource var2, int var3, HumanoidArm var4);

    @Inject(method={"renderArmWithItem(Lnet/minecraft/client/player/AbstractClientPlayer;FFLnet/minecraft/world/InteractionHand;FLnet/minecraft/world/item/ItemStack;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEmpty()Z", ordinal=0)}, cancellable=true)
    private void renderPhotograph(AbstractClientPlayer player, float partialTicks, float pitch, InteractionHand hand, float swingProgress, ItemStack stack, float equipProgress, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, CallbackInfo ci, @Local boolean isMainHand, @Local HumanoidArm arm) {
        if (CameraClient.viewfinder() != null && CameraClient.viewfinder().isLookingThrough()) {
            poseStack.popPose();
            ci.cancel();
            return;
        }
        if (stack.getItem() instanceof PhotographItem || stack.getItem() instanceof StackedPhotographsItem) {
            if (isMainHand && this.offHandItem.isEmpty()) {
                this.exposure$renderTwoHandedPhotograph(player, poseStack, buffer, combinedLight, pitch, equipProgress, swingProgress);
            } else {
                this.exposure$renderOneHandedPhotograph(player, poseStack, buffer, combinedLight, equipProgress, arm, swingProgress, stack);
            }
            poseStack.popPose();
            ci.cancel();
        }
    }

    @Unique
    private void exposure$renderOneHandedPhotograph(AbstractClientPlayer player, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float pEquippedProgress, HumanoidArm pHand, float pSwingProgress, ItemStack stack) {
        float f = pHand == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        poseStack.translate((double)(f * 0.125f), -0.125, 0.0);
        if (!player.isInvisible()) {
            poseStack.pushPose();
            poseStack.mulPose(Axis.ZP.rotationDegrees(f * 10.0f));
            this.renderPlayerArm(poseStack, buffer, packedLight, pEquippedProgress, pSwingProgress, pHand);
            poseStack.popPose();
        }
        poseStack.pushPose();
        poseStack.translate((double)(f * 0.51f), (double)(-0.08f + pEquippedProgress * -1.2f), -0.75);
        float f1 = Mth.sqrt((float)pSwingProgress);
        float f2 = Mth.sin((float)(f1 * (float)Math.PI));
        float f3 = -0.5f * f2;
        float f4 = 0.4f * Mth.sin((float)(f1 * ((float)Math.PI * 2)));
        float f5 = -0.3f * Mth.sin((float)(pSwingProgress * (float)Math.PI));
        poseStack.translate(f * f3, f4 - 0.3f * f2, f5);
        poseStack.mulPose(Axis.XP.rotationDegrees(f2 * -45.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(f * f2 * -30.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        poseStack.scale(0.38f, 0.38f, 0.38f);
        poseStack.translate(-0.5, -0.5, 0.0);
        poseStack.scale(1.0f, 1.0f, -1.0f);
        ExposureClient.photographRenderer().render(stack, true, false, poseStack, buffer, packedLight);
        poseStack.popPose();
    }

    @Unique
    private void exposure$renderTwoHandedPhotograph(AbstractClientPlayer player, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float pitch, float equippedProgress, float swingProgress) {
        float f = Mth.sqrt((float)swingProgress);
        float f1 = -0.2f * Mth.sin((float)(swingProgress * (float)Math.PI));
        float f2 = -0.4f * Mth.sin((float)(f * (float)Math.PI));
        poseStack.translate(0.0, (double)(-f1 / 2.0f), (double)f2);
        float f3 = this.calculateMapTilt(pitch);
        poseStack.translate(0.0, (double)(0.04f + equippedProgress * -1.2f + f3 * -0.5f), (double)-0.72f);
        poseStack.mulPose(Axis.XP.rotationDegrees(f3 * -85.0f));
        if (!player.isInvisible()) {
            poseStack.pushPose();
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            this.renderMapHand(poseStack, buffer, packedLight, HumanoidArm.RIGHT);
            this.renderMapHand(poseStack, buffer, packedLight, HumanoidArm.LEFT);
            poseStack.popPose();
        }
        float f4 = Mth.sin((float)(f * (float)Math.PI));
        poseStack.mulPose(Axis.XP.rotationDegrees(f4 * 20.0f));
        poseStack.scale(2.0f, 2.0f, 2.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        poseStack.scale(0.38f, 0.38f, 0.38f);
        poseStack.translate(-0.5, -0.5, 0.0);
        poseStack.scale(1.0f, 1.0f, -1.0f);
        ExposureClient.photographRenderer().render(this.mainHandItem, true, false, poseStack, buffer, packedLight);
    }
}

