/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.compat.recipeviewers.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.subtypes.PropertyBasedSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public class DyeRecipesMaker {
    private DyeRecipesMaker() {
    }

    public static <T extends PropertyBasedSubtypeInterpreter> List<RecipeHolder<CraftingRecipe>> getRecipes(Function<ItemStack, Optional<T>> getSubtypeInterpreter) {
        return DyeRecipesMaker.getRecipes(getSubtypeInterpreter, RecipeHolder::new);
    }

    public static <R, T extends PropertyBasedSubtypeInterpreter> List<R> getRecipes(Function<ItemStack, Optional<T>> getSubtypeInterpreter, BiFunction<ResourceLocation, ShapedRecipe, R> transformRecipe) {
        ArrayList recipes = new ArrayList();
        HashMap<Item, ItemStack[]> blocks = new HashMap<Item, ItemStack[]>();
        blocks.put((Item)ModBlocks.BARREL_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.BARREL.get()));
        blocks.put((Item)ModBlocks.COPPER_BARREL_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.COPPER_BARREL.get()));
        blocks.put((Item)ModBlocks.IRON_BARREL_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.IRON_BARREL.get()));
        blocks.put((Item)ModBlocks.GOLD_BARREL_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.GOLD_BARREL.get()));
        blocks.put((Item)ModBlocks.DIAMOND_BARREL_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.DIAMOND_BARREL.get()));
        blocks.put((Item)ModBlocks.NETHERITE_BARREL_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.NETHERITE_BARREL.get()));
        blocks.put((Item)ModBlocks.CHEST_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.CHEST.get()));
        blocks.put((Item)ModBlocks.COPPER_CHEST_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.COPPER_CHEST.get()));
        blocks.put((Item)ModBlocks.IRON_CHEST_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.IRON_CHEST.get()));
        blocks.put((Item)ModBlocks.GOLD_CHEST_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.GOLD_CHEST.get()));
        blocks.put((Item)ModBlocks.DIAMOND_CHEST_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.DIAMOND_CHEST.get()));
        blocks.put((Item)ModBlocks.NETHERITE_CHEST_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.NETHERITE_CHEST.get()));
        blocks.put((Item)ModBlocks.SHULKER_BOX_ITEM.get(), new ItemStack[]{new ItemStack((ItemLike)ModBlocks.SHULKER_BOX_ITEM.get())});
        blocks.put((Item)ModBlocks.COPPER_SHULKER_BOX_ITEM.get(), new ItemStack[]{new ItemStack((ItemLike)ModBlocks.COPPER_SHULKER_BOX_ITEM.get())});
        blocks.put((Item)ModBlocks.IRON_SHULKER_BOX_ITEM.get(), new ItemStack[]{new ItemStack((ItemLike)ModBlocks.IRON_SHULKER_BOX_ITEM.get())});
        blocks.put((Item)ModBlocks.GOLD_SHULKER_BOX_ITEM.get(), new ItemStack[]{new ItemStack((ItemLike)ModBlocks.GOLD_SHULKER_BOX_ITEM.get())});
        blocks.put((Item)ModBlocks.DIAMOND_SHULKER_BOX_ITEM.get(), new ItemStack[]{new ItemStack((ItemLike)ModBlocks.DIAMOND_SHULKER_BOX_ITEM.get())});
        blocks.put((Item)ModBlocks.NETHERITE_SHULKER_BOX_ITEM.get(), new ItemStack[]{new ItemStack((ItemLike)ModBlocks.NETHERITE_SHULKER_BOX_ITEM.get())});
        blocks.put((Item)ModBlocks.LIMITED_BARREL_1_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.LIMITED_BARREL_1.get()));
        blocks.put((Item)ModBlocks.LIMITED_COPPER_BARREL_1_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.LIMITED_COPPER_BARREL_1.get()));
        blocks.put((Item)ModBlocks.LIMITED_IRON_BARREL_1_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.LIMITED_IRON_BARREL_1.get()));
        blocks.put((Item)ModBlocks.LIMITED_GOLD_BARREL_1_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.LIMITED_GOLD_BARREL_1.get()));
        blocks.put((Item)ModBlocks.LIMITED_DIAMOND_BARREL_1_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.LIMITED_DIAMOND_BARREL_1.get()));
        blocks.put((Item)ModBlocks.LIMITED_NETHERITE_BARREL_1_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.LIMITED_NETHERITE_BARREL_1.get()));
        blocks.put((Item)ModBlocks.LIMITED_BARREL_2_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.LIMITED_BARREL_2.get()));
        blocks.put((Item)ModBlocks.LIMITED_COPPER_BARREL_2_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.LIMITED_COPPER_BARREL_2.get()));
        blocks.put((Item)ModBlocks.LIMITED_IRON_BARREL_2_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.LIMITED_IRON_BARREL_2.get()));
        blocks.put((Item)ModBlocks.LIMITED_GOLD_BARREL_2_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.LIMITED_GOLD_BARREL_2.get()));
        blocks.put((Item)ModBlocks.LIMITED_DIAMOND_BARREL_2_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.LIMITED_DIAMOND_BARREL_2.get()));
        blocks.put((Item)ModBlocks.LIMITED_NETHERITE_BARREL_2_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.LIMITED_NETHERITE_BARREL_2.get()));
        blocks.put((Item)ModBlocks.LIMITED_BARREL_3_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.LIMITED_BARREL_3.get()));
        blocks.put((Item)ModBlocks.LIMITED_COPPER_BARREL_3_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.LIMITED_COPPER_BARREL_3.get()));
        blocks.put((Item)ModBlocks.LIMITED_IRON_BARREL_3_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.LIMITED_IRON_BARREL_3.get()));
        blocks.put((Item)ModBlocks.LIMITED_GOLD_BARREL_3_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.LIMITED_GOLD_BARREL_3.get()));
        blocks.put((Item)ModBlocks.LIMITED_DIAMOND_BARREL_3_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.LIMITED_DIAMOND_BARREL_3.get()));
        blocks.put((Item)ModBlocks.LIMITED_NETHERITE_BARREL_3_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.LIMITED_NETHERITE_BARREL_3.get()));
        blocks.put((Item)ModBlocks.LIMITED_BARREL_4_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.LIMITED_BARREL_4.get()));
        blocks.put((Item)ModBlocks.LIMITED_COPPER_BARREL_4_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.LIMITED_COPPER_BARREL_4.get()));
        blocks.put((Item)ModBlocks.LIMITED_IRON_BARREL_4_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.LIMITED_IRON_BARREL_4.get()));
        blocks.put((Item)ModBlocks.LIMITED_GOLD_BARREL_4_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.LIMITED_GOLD_BARREL_4.get()));
        blocks.put((Item)ModBlocks.LIMITED_DIAMOND_BARREL_4_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.LIMITED_DIAMOND_BARREL_4.get()));
        blocks.put((Item)ModBlocks.LIMITED_NETHERITE_BARREL_4_ITEM.get(), DyeRecipesMaker.getWoodStorageStacks(ModBlocks.LIMITED_NETHERITE_BARREL_4.get()));
        DyeRecipesMaker.addSingleColorRecipes(recipes, blocks, getSubtypeInterpreter, transformRecipe);
        DyeRecipesMaker.addMultipleColorsRecipe(recipes, blocks, getSubtypeInterpreter, transformRecipe);
        return recipes;
    }

    private static ItemStack[] getWoodStorageStacks(StorageBlockBase woodStorageBlock) {
        HashSet ret = new HashSet();
        WoodStorageBlockBase.CUSTOM_TEXTURE_WOOD_TYPES.keySet().forEach(woodType -> ret.add(WoodStorageBlockItem.setWoodType(new ItemStack((ItemLike)woodStorageBlock), woodType)));
        return ret.toArray(new ItemStack[0]);
    }

    private static <R, T extends PropertyBasedSubtypeInterpreter> void addMultipleColorsRecipe(List<R> recipes, Map<Item, ItemStack[]> items, Function<ItemStack, Optional<T>> getSubtypeInterpreter, BiFunction<ResourceLocation, ShapedRecipe, R> transformRecipe) {
        items.forEach((block, stacks) -> {
            NonNullList ingredients = NonNullList.create();
            ingredients.add((Object)Ingredient.of((TagKey)DyeColor.YELLOW.getTag()));
            ingredients.add((Object)Ingredient.of((ItemStack[])stacks));
            ingredients.add((Object)Ingredient.of((TagKey)DyeColor.LIME.getTag()));
            ItemStack result = new ItemStack((ItemLike)block);
            Item patt0$temp = result.getItem();
            if (patt0$temp instanceof ITintableBlockItem) {
                ITintableBlockItem tintableBlockItem = (ITintableBlockItem)patt0$temp;
                tintableBlockItem.setMainColor(result, DyeColor.YELLOW.getTextureDiffuseColor());
                tintableBlockItem.setAccentColor(result, DyeColor.LIME.getTextureDiffuseColor());
            }
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"sophisticatedstorage", (String)((Optional)getSubtypeInterpreter.apply(result)).map(i -> i.getRegistrySanitizedItemString(result)).orElse("multiple_color"));
            ShapedRecipePattern pattern = new ShapedRecipePattern(3, 1, ingredients, Optional.empty());
            recipes.add(transformRecipe.apply(id, new ShapedRecipe("", CraftingBookCategory.MISC, pattern, result)));
        });
    }

    private static <R, T extends PropertyBasedSubtypeInterpreter> void addSingleColorRecipes(List<R> recipes, Map<Item, ItemStack[]> items, Function<ItemStack, Optional<T>> getSubtypeInterpreter, BiFunction<ResourceLocation, ShapedRecipe, R> transformRecipe) {
        for (DyeColor color : DyeColor.values()) {
            items.forEach((block, stacks) -> {
                NonNullList ingredients = NonNullList.create();
                ingredients.add((Object)Ingredient.of((ItemStack[])stacks));
                ingredients.add((Object)Ingredient.of((TagKey)color.getTag()));
                ItemStack result = new ItemStack((ItemLike)block);
                Item patt0$temp = result.getItem();
                if (patt0$temp instanceof ITintableBlockItem) {
                    ITintableBlockItem tintableBlockItem = (ITintableBlockItem)patt0$temp;
                    tintableBlockItem.setMainColor(result, color.getTextureDiffuseColor());
                    tintableBlockItem.setAccentColor(result, color.getTextureDiffuseColor());
                }
                ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"sophisticatedstorage", (String)((Optional)getSubtypeInterpreter.apply(result)).map(i -> i.getRegistrySanitizedItemString(result)).orElse("single_color_" + color.getSerializedName()));
                ShapedRecipePattern pattern = new ShapedRecipePattern(1, 2, ingredients, Optional.empty());
                recipes.add(transformRecipe.apply(id, new ShapedRecipe("", CraftingBookCategory.MISC, pattern, result)));
            });
        }
    }
}

