/*
 * Decompiled with CFR 0.152.
 */
package me.isaiah.multiworld.command;

import java.io.File;
import java.util.HashMap;
import me.isaiah.multiworld.I18n;
import me.isaiah.multiworld.MultiworldMod;
import me.isaiah.multiworld.command.Command;
import me.isaiah.multiworld.command.SpawnCommand;
import me.isaiah.multiworld.config.FileConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Blocks;

public class TpCommand
implements Command {
    public static int run(MinecraftServer mc, ServerPlayer plr, String[] args) {
        HashMap worlds = new HashMap();
        mc.levelKeys().forEach(r -> {
            ServerLevel world = mc.getLevel(r);
            worlds.put(r.location().toString(), world);
        });
        Object arg1 = args[1];
        if (((String)arg1).indexOf(58) == -1) {
            arg1 = "multiworld:" + (String)arg1;
        }
        if (null == plr) {
            if (args.length <= 2) {
                return 0;
            }
            String target = args[2];
            plr = mc.getPlayerList().getPlayerByName(target);
        }
        if (worlds.containsKey(arg1)) {
            ServerLevel w = (ServerLevel)worlds.get(arg1);
            BlockPos sp = SpawnCommand.getSpawn(w);
            boolean isEnd = false;
            try {
                boolean is_the_end = MultiworldMod.get_world_creator().is_the_end(w);
                if (is_the_end) {
                    isEnd = true;
                }
            }
            catch (Exception | NoSuchMethodError is_the_end) {
                // empty catch block
            }
            String env = TpCommand.read_env_from_config((String)arg1);
            if (null != env && env.equalsIgnoreCase("END")) {
                isEnd = true;
            }
            if (isEnd) {
                TpCommand.method_29200_createEndSpawnPlatform(w);
                sp = ServerLevel.END_SPAWN_POINT;
            }
            if (null == sp) {
                I18n.message(plr, "&4Error: null getSpawnPos");
                sp = new BlockPos(1, 40, 1);
            }
            I18n.message(plr, "&6Teleporting...");
            sp = TpCommand.findSafePos(w, sp);
            MultiworldMod.get_world_creator().teleleport(plr, w, sp.getX(), sp.getY(), sp.getZ());
            return 1;
        }
        return 1;
    }

    public static void method_29200_createEndSpawnPlatform(ServerLevel world) {
        BlockPos lv = ServerLevel.END_SPAWN_POINT;
        int i = lv.getX();
        int j = lv.getY() - 2;
        int k = lv.getZ();
        BlockPos.betweenClosed((int)(i - 2), (int)(j + 1), (int)(k - 2), (int)(i + 2), (int)(j + 3), (int)(k + 2)).forEach(pos -> world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState()));
        BlockPos.betweenClosed((int)(i - 2), (int)j, (int)(k - 2), (int)(i + 2), (int)j, (int)(k + 2)).forEach(pos -> world.setBlockAndUpdate(pos, Blocks.OBSIDIAN.defaultBlockState()));
    }

    private static BlockPos findSafePos(ServerLevel w, BlockPos sp) {
        BlockPos pos = sp;
        while (w.getBlockState(pos) != Blocks.AIR.defaultBlockState()) {
            pos = pos.offset(0, 1, 0);
        }
        return pos;
    }

    public static BlockPos multiworld_method_43126(ServerLevel world) {
        return SpawnCommand.multiworld_method_43126(world);
    }

    public static String read_env_from_config(String id) {
        File config_dir = new File("config");
        config_dir.mkdirs();
        String[] spl = id.split(":");
        File cf = new File(config_dir, "multiworld");
        cf.mkdirs();
        File worlds = new File(cf, "worlds");
        worlds.mkdirs();
        File namespace = new File(worlds, spl[0]);
        namespace.mkdirs();
        File wc = new File(namespace, spl[1] + ".yml");
        try {
            if (!wc.exists()) {
                wc.createNewFile();
            }
            FileConfiguration config = new FileConfiguration(wc);
            String env = config.getString("environment");
            return env;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "NORMAL";
        }
    }
}

