/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.data.resources.registries;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlockStateProperties;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.data.resources.builders.AetherStructureBuilders;
import com.aetherteam.aether.data.resources.registries.AetherConfiguredFeatures;
import com.aetherteam.aether.data.resources.registries.AetherPlacedFeatures;
import com.aetherteam.aether.data.resources.registries.AetherStructureProcessorLists;
import com.aetherteam.aether.world.structure.BronzeDungeonStructure;
import com.aetherteam.aether.world.structure.GoldDungeonStructure;
import com.aetherteam.aether.world.structure.LargeAercloudStructure;
import com.aetherteam.aether.world.structure.SilverDungeonStructure;
import com.aetherteam.aether.world.structurepiece.bronzedungeon.BronzeProcessorSettings;
import com.aetherteam.aether.world.structurepiece.golddungeon.GoldProcessorSettings;
import com.aetherteam.aether.world.structurepiece.silverdungeon.SilverProcessorSettings;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class AetherStructures {
    public static final ResourceKey<Structure> LARGE_AERCLOUD = AetherStructures.createKey("large_aercloud");
    public static final ResourceKey<Structure> BRONZE_DUNGEON = AetherStructures.createKey("bronze_dungeon");
    public static final ResourceKey<Structure> SILVER_DUNGEON = AetherStructures.createKey("silver_dungeon");
    public static final ResourceKey<Structure> GOLD_DUNGEON = AetherStructures.createKey("gold_dungeon");

    private static ResourceKey<Structure> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aether", (String)name));
    }

    public static void bootstrap(BootstrapContext<Structure> context) {
        Map<MobCategory, StructureSpawnOverride> mobSpawnsBox = Arrays.stream(MobCategory.values()).collect(Collectors.toMap(category -> category, category -> new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.create())));
        Map<MobCategory, StructureSpawnOverride> mobSpawnsPiece = Arrays.stream(MobCategory.values()).collect(Collectors.toMap(category -> category, category -> new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, WeightedRandomList.create())));
        HolderGetter biomes = context.lookup(Registries.BIOME);
        HolderGetter placements = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter configurations = context.lookup(Registries.CONFIGURED_FEATURE);
        HolderGetter processors = context.lookup(Registries.PROCESSOR_LIST);
        context.register(LARGE_AERCLOUD, (Object)new LargeAercloudStructure(AetherStructureBuilders.structure((HolderSet<Biome>)biomes.getOrThrow(AetherTags.Biomes.HAS_LARGE_AERCLOUD), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)AetherBlocks.COLD_AERCLOUD.get()).defaultBlockState().setValue((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true)))), 3, 32));
        context.register(BRONZE_DUNGEON, (Object)new BronzeDungeonStructure(AetherStructureBuilders.structure((HolderSet<Biome>)biomes.getOrThrow(AetherTags.Biomes.HAS_BRONZE_DUNGEON), mobSpawnsPiece, GenerationStep.Decoration.TOP_LAYER_MODIFICATION, TerrainAdjustment.NONE), 8, 32, 24, new BronzeProcessorSettings((Holder<StructureProcessorList>)processors.getOrThrow(AetherStructureProcessorLists.BRONZE_ROOM), (Holder<StructureProcessorList>)processors.getOrThrow(AetherStructureProcessorLists.BRONZE_TUNNEL), (Holder<StructureProcessorList>)processors.getOrThrow(AetherStructureProcessorLists.BRONZE_BOSS_ROOM))));
        context.register(SILVER_DUNGEON, (Object)new SilverDungeonStructure(AetherStructureBuilders.structure((HolderSet<Biome>)biomes.getOrThrow(AetherTags.Biomes.HAS_SILVER_DUNGEON), mobSpawnsBox, GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE), 128, 2, 18, 35, 70, new SilverProcessorSettings((Holder<StructureProcessorList>)processors.getOrThrow(AetherStructureProcessorLists.SILVER_ROOM), (Holder<StructureProcessorList>)processors.getOrThrow(AetherStructureProcessorLists.SILVER_FLOOR), (Holder<StructureProcessorList>)processors.getOrThrow(AetherStructureProcessorLists.SILVER_BOSS_ROOM))));
        context.register(GOLD_DUNGEON, (Object)new GoldDungeonStructure(AetherStructureBuilders.structure((HolderSet<Biome>)biomes.getOrThrow(AetherTags.Biomes.HAS_GOLD_DUNGEON), mobSpawnsBox, GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE), 8, 20, 40, 60, (Holder<PlacedFeature>)placements.getOrThrow(AetherPlacedFeatures.GOLD_DUNGEON_ISLAND_FOLIAGE), (Holder<PlacedFeature>)PlacementUtils.inlinePlaced((Holder)configurations.getOrThrow(AetherConfiguredFeatures.GOLDEN_OAK_TREE_CONFIGURATION), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)64)}), new GoldProcessorSettings((Holder<StructureProcessorList>)processors.getOrThrow(AetherStructureProcessorLists.GOLD_ISLAND), (Holder<StructureProcessorList>)processors.getOrThrow(AetherStructureProcessorLists.GOLD_TUNNEL), (Holder<StructureProcessorList>)processors.getOrThrow(AetherStructureProcessorLists.GOLD_BOSS_ROOM))));
    }
}

