/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.network.packet.serverbound;

import com.aetherteam.aether.entity.projectile.weapon.HammerProjectile;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record HammerProjectileLaunchPacket(int targetID, int projectileID) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<HammerProjectileLaunchPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"launch_hammer_projectile"));
    public static final StreamCodec<RegistryFriendlyByteBuf, HammerProjectileLaunchPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, HammerProjectileLaunchPacket::targetID, (StreamCodec)ByteBufCodecs.INT, HammerProjectileLaunchPacket::projectileID, HammerProjectileLaunchPacket::new);

    public CustomPacketPayload.Type<HammerProjectileLaunchPacket> type() {
        return TYPE;
    }

    public static void execute(HammerProjectileLaunchPacket payload, IPayloadContext context) {
        Player playerEntity = context.player();
        if (playerEntity.getServer() != null) {
            Entity target = playerEntity.level().getEntity(payload.targetID());
            Entity projectile = playerEntity.level().getEntity(payload.projectileID());
            if (projectile instanceof HammerProjectile) {
                HammerProjectile hammerProjectile = (HammerProjectile)projectile;
                hammerProjectile.launchTarget(target);
            }
        }
    }
}

