/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.content.block;

import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import dev.xkmc.fruitsdelight.content.block.BaseLeavesBlock;
import dev.xkmc.fruitsdelight.init.data.FDModConfig;
import dev.xkmc.fruitsdelight.init.plants.Durian;
import dev.xkmc.l2core.serial.loot.LootHelper;
import dev.xkmc.l2harvester.api.HarvestResult;
import dev.xkmc.l2harvester.api.HarvestableBlock;
import java.util.List;
import java.util.Locale;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class DurianLeavesBlock
extends BaseLeavesBlock
implements HarvestableBlock {
    public static final EnumProperty<Fruit> FRUIT = EnumProperty.create((String)"fruit", Fruit.class);
    public static final EnumProperty<Leaf> LEAF = EnumProperty.create((String)"leaf", Leaf.class);
    private static final VoxelShape BID = Block.box((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);

    public DurianLeavesBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return state.getValue(LEAF) == Leaf.BARE ? BID : super.getShape(state, level, pos, ctx);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return state.getValue(LEAF) != Leaf.BARE || level.getBlockState(pos.above()).is((Block)this);
    }

    @Override
    protected InteractionResult doClick(Level level, BlockPos pos, BlockState state) {
        if (state.getValue(FRUIT) == Fruit.FRUITS) {
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                this.dropFruit(state, sl, pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public HarvestResult getHarvestResult(Level level, BlockState state, BlockPos pos) {
        if (((Boolean)state.getValue((Property)PERSISTENT)).booleanValue()) {
            return null;
        }
        if (state.getValue(FRUIT) != Fruit.FRUITS) {
            return null;
        }
        return new HarvestResult((l, p) -> this.postDropFruit(state, (ServerLevel)l, (BlockPos)p), List.of(Durian.FRUIT.asStack()));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LEAF, FRUIT});
    }

    protected boolean doDropFruit(BlockState state, ServerLevel level, BlockPos pos) {
        BlockState curSt = state;
        BlockPos curPos = pos;
        while (!curSt.canBeReplaced()) {
            if (!(curSt.getBlock() instanceof BaseLeavesBlock)) {
                return false;
            }
            curPos = curPos.below();
            curSt = level.getBlockState(curPos);
        }
        FallingBlockEntity.fall((Level)level, (BlockPos)pos, (BlockState)Durian.FRUIT.getDefaultState());
        return true;
    }

    protected boolean createFlower(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.isOutsideBuildHeight(pos.below())) {
            return false;
        }
        BlockState below = level.getBlockState(pos.below());
        if (below.isAir()) {
            BlockState next = (BlockState)((BlockState)((BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(LEAF, (Comparable)((Object)Leaf.BARE))).setValue(FRUIT, (Comparable)((Object)Fruit.FLOWERS));
            level.setBlockAndUpdate(pos.below(), next);
            return true;
        }
        if (below.is((Block)this) && below.getValue(FRUIT) == Fruit.NONE) {
            level.setBlockAndUpdate(pos.below(), (BlockState)below.setValue(FRUIT, (Comparable)((Object)Fruit.FLOWERS)));
            return true;
        }
        return false;
    }

    protected void dropFruit(BlockState state, ServerLevel level, BlockPos pos) {
        if (this.doDropFruit(state, level, pos)) {
            this.postDropFruit(state, level, pos);
        }
    }

    protected void postDropFruit(BlockState state, ServerLevel level, BlockPos pos) {
        if (state.getValue(LEAF) == Leaf.BARE) {
            level.removeBlock(pos, false);
        } else {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue(FRUIT, (Comparable)((Object)Fruit.NONE)));
        }
    }

    public boolean isRandomlyTicking(BlockState state) {
        if (((Boolean)state.getValue((Property)PERSISTENT)).booleanValue()) {
            return false;
        }
        if (state.getValue(LEAF) == Leaf.BUDDING) {
            return true;
        }
        if (state.getValue(FRUIT) != Fruit.NONE) {
            return true;
        }
        return super.isRandomlyTicking(state);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.getValue((Property)PERSISTENT)).booleanValue() && !this.decaying(state)) {
            boolean grow;
            Fruit st = (Fruit)((Object)state.getValue(FRUIT));
            if (st == Fruit.FLOWERS) {
                boolean bl = grow = random.nextDouble() < (Double)FDModConfig.SERVER.fruitsGrowChance.get();
                if (CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (boolean)grow)) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue(FRUIT, (Comparable)((Object)Fruit.SMALL)));
                    CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                    return;
                }
            }
            if (st == Fruit.SMALL) {
                boolean bl = grow = random.nextDouble() < (Double)FDModConfig.SERVER.fruitsGrowChance.get();
                if (CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (boolean)grow)) {
                    if ((Double)FDModConfig.SERVER.fruitsDropChance.get() < (Double)FDModConfig.SERVER.fruitsGrowChance.get()) {
                        level.setBlockAndUpdate(pos, (BlockState)state.setValue(FRUIT, (Comparable)((Object)Fruit.FRUITS)));
                    } else {
                        this.dropFruit(state, level, pos);
                    }
                    CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                    return;
                }
            }
            if (st == Fruit.FRUITS && random.nextDouble() < (Double)FDModConfig.SERVER.fruitsDropChance.get()) {
                this.dropFruit(state, level, pos);
                return;
            }
            Leaf leaf = (Leaf)((Object)state.getValue(LEAF));
            if (st == Fruit.NONE && leaf == Leaf.BUDDING) {
                boolean grow2;
                boolean bl = grow2 = random.nextDouble() < (Double)FDModConfig.SERVER.fruitsGrowChance.get();
                if (CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (boolean)grow2) && this.createFlower(state, level, pos, random)) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue(LEAF, (Comparable)((Object)Leaf.LEAF)));
                    BlockPos next = this.findNextFlowerTarget((Level)level, pos, e -> (Boolean)e.getValue((Property)PERSISTENT) == false && e.getValue(LEAF) == Leaf.LEAF);
                    if (next != null) {
                        BlockState ns = level.getBlockState(next);
                        level.setBlockAndUpdate(next, (BlockState)ns.setValue(LEAF, (Comparable)((Object)Leaf.BUDDING)));
                    }
                    return;
                }
            }
        }
        super.randomTick(state, level, pos, random);
    }

    @Override
    public BlockState flowerState() {
        return (BlockState)this.defaultBlockState().setValue(LEAF, (Comparable)((Object)Leaf.BUDDING));
    }

    @Override
    public void buildLeavesModel(DataGenContext<Block, ? extends BaseLeavesBlock> ctx, RegistrateBlockstateProvider pvd, String name) {
        BlockModelBuilder leaves = (BlockModelBuilder)((BlockModelBuilder)pvd.models().withExistingParent(name + "_leaves", "block/leaves")).texture("all", "block/" + name + "_leaves");
        BlockModelBuilder flowers = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().withExistingParent(name + "_flowers", "block/cross")).texture("cross", "block/" + name + "_flowers")).renderType("cutout");
        BlockModelBuilder small = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().getBuilder(name + "_small")).parent((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("block/durian_small_base")))).texture("top", pvd.modLoc("block/durian_top_small"))).texture("side", pvd.modLoc("block/durian_side_small"))).renderType("cutout");
        BlockModelBuilder fruits = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().getBuilder(name + "_fruits")).parent((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("block/durian_base")))).texture("top", pvd.modLoc("block/durian_top"))).texture("side", pvd.modLoc("block/durian_side"))).renderType("cutout");
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)pvd.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)leaves).addModel()).condition(LEAF, (Comparable[])new Leaf[]{Leaf.LEAF, Leaf.BUDDING}).end().part().modelFile((ModelFile)flowers).addModel()).condition(FRUIT, (Comparable[])new Fruit[]{Fruit.FLOWERS}).end().part().modelFile((ModelFile)small).addModel()).condition(FRUIT, (Comparable[])new Fruit[]{Fruit.SMALL}).end().part().modelFile((ModelFile)fruits).addModel()).condition(FRUIT, (Comparable[])new Fruit[]{Fruit.FRUITS}).end();
    }

    @Override
    public void buildLoot(RegistrateBlockLootTables pvd, Block block, Block sapling, Item fruit) {
        LootHelper helper = new LootHelper(pvd);
        AnyOfCondition.Builder cond = helper.silk().or(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(Tags.Items.TOOLS_SHEAR)));
        LootPoolSingletonContainer.Builder leaves = (LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(helper.enumState(block, LEAF, (Comparable)((Object)Leaf.BARE)).invert())).when((LootItemCondition.Builder)cond);
        LootPoolSingletonContainer.Builder fruits = (LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)fruit).when(helper.enumState(block, FRUIT, (Comparable)((Object)Fruit.FRUITS)));
        AlternativesEntry.Builder drops = AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{leaves, fruits});
        pvd.add(block, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)drops).when(ExplosionCondition.survivesExplosion())));
    }

    public static enum Leaf implements StringRepresentable
    {
        LEAF,
        BUDDING,
        BARE;


        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum Fruit implements StringRepresentable
    {
        NONE,
        FLOWERS,
        SMALL,
        FRUITS;


        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

