/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.content.block;

import dev.xkmc.fruitsdelight.content.block.BaseCakeBlock;
import dev.xkmc.fruitsdelight.init.food.FDFood;
import dev.xkmc.l2modularblock.core.VoxelBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.tag.CommonTags;

public class FigPuddingBlock
extends BaseCakeBlock {
    public static final int MAX_BITES = 3;
    public static final IntegerProperty BITES = IntegerProperty.create((String)"bites", (int)0, (int)3);
    protected static final VoxelShape[][] SHAPES = new VoxelShape[4][4];

    public FigPuddingBlock(BlockBehaviour.Properties properties) {
        super(properties, BITES, 3, false);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        int bite = (Integer)state.getValue((Property)BITES);
        Direction dir = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return SHAPES[dir.get2DDataValue()][bite];
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(CommonTags.TOOLS_KNIFE)) {
            int i = (Integer)state.getValue((Property)this.bite);
            if (i > 0) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)this.bite, (Comparable)Integer.valueOf(i - 1)));
            } else {
                level.playSound(null, pos, SoundEvents.WOOD_BREAK, SoundSource.PLAYERS, 0.8f, 0.8f);
                level.destroyBlock(pos, true);
            }
            FigPuddingBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)FDFood.FIG_PUDDING_SLICE.get().getDefaultInstance());
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    protected void eat(Player player) {
        player.eat(player.level(), FDFood.FIG_PUDDING_SLICE.item.asStack());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING, BITES});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    static {
        VoxelBuilder root = new VoxelBuilder(8, 0, 8, 13, 6, 13);
        VoxelBuilder peak = new VoxelBuilder(8, 6, 8, 10, 8, 10);
        VoxelShape complete = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0);
        for (Direction dir : Direction.values()) {
            if (dir.getAxis() == Direction.Axis.Y) continue;
            for (int bite = 0; bite < 4; ++bite) {
                VoxelShape[] voxelShapeArray = SHAPES[dir.get2DDataValue()];
                voxelShapeArray[bite] = switch (bite) {
                    case 0 -> Shapes.or((VoxelShape)peak.rotateFromNorth(dir), (VoxelShape)root.rotateFromNorth(dir));
                    case 1 -> Shapes.or((VoxelShape)peak.rotateFromNorth(dir), (VoxelShape[])new VoxelShape[]{root.rotateFromNorth(dir), root.rotateFromNorth(dir.getClockWise())});
                    case 2 -> Shapes.or((VoxelShape)peak.rotateFromNorth(dir), (VoxelShape[])new VoxelShape[]{root.rotateFromNorth(dir), root.rotateFromNorth(dir.getClockWise()), root.rotateFromNorth(dir.getCounterClockWise())});
                    default -> Shapes.or((VoxelShape)peak.rotateFromNorth(dir), (VoxelShape)complete);
                };
            }
        }
    }
}

