/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.content.block;

import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import dev.xkmc.fruitsdelight.content.block.BaseLeavesBlock;
import dev.xkmc.fruitsdelight.init.data.FDModConfig;
import dev.xkmc.l2core.serial.loot.LootHelper;
import dev.xkmc.l2harvester.api.HarvestResult;
import dev.xkmc.l2harvester.api.HarvestableBlock;
import java.util.Locale;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class PassableLeavesBlock
extends BaseLeavesBlock
implements BonemealableBlock,
HarvestableBlock {
    public static final EnumProperty<State> STATE = EnumProperty.create((String)"type", State.class);

    public PassableLeavesBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    @Override
    protected InteractionResult doClick(Level level, BlockPos pos, BlockState state) {
        if (state.getValue(STATE) == State.FRUITS) {
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                this.dropFruit(state, sl, pos, level.getRandom());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public HarvestResult getHarvestResult(Level level, BlockState state, BlockPos pos) {
        if (((Boolean)state.getValue((Property)PERSISTENT)).booleanValue()) {
            return null;
        }
        if (state.getValue(STATE) != State.FRUITS) {
            return null;
        }
        return new HarvestResult((BlockState)state.setValue(STATE, (Comparable)((Object)State.LEAVES)), PassableLeavesBlock.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{STATE});
    }

    protected void doDropFruit(BlockState state, ServerLevel level, BlockPos pos) {
        PassableLeavesBlock.dropResources((BlockState)state, (Level)level, (BlockPos)pos);
    }

    protected void dropFruit(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.doDropFruit(state, level, pos);
        level.setBlockAndUpdate(pos, (BlockState)state.setValue(STATE, (Comparable)((Object)State.LEAVES)));
    }

    public boolean isRandomlyTicking(BlockState state) {
        if (((Boolean)state.getValue((Property)PERSISTENT)).booleanValue()) {
            return false;
        }
        if (state.getValue(STATE) != State.LEAVES) {
            return true;
        }
        return super.isRandomlyTicking(state);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.getValue((Property)PERSISTENT)).booleanValue() && !this.decaying(state)) {
            State st = (State)((Object)state.getValue(STATE));
            if (st == State.FLOWERS) {
                boolean grow;
                boolean bl = grow = random.nextDouble() < (Double)FDModConfig.SERVER.fruitsGrowChance.get();
                if (CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (boolean)grow)) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue(STATE, (Comparable)((Object)State.FRUITS)));
                    BlockPos next = this.findNextFlowerTarget((Level)level, pos, e -> (Boolean)e.getValue((Property)PERSISTENT) == false && e.getValue(STATE) == State.LEAVES);
                    if (next != null) {
                        BlockState ns = level.getBlockState(next);
                        level.setBlockAndUpdate(next, (BlockState)ns.setValue(STATE, (Comparable)((Object)State.FLOWERS)));
                    }
                    CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                    return;
                }
            }
            if (st == State.FRUITS && random.nextDouble() < (Double)FDModConfig.SERVER.fruitsDropChance.get()) {
                this.dropFruit(state, level, pos, random);
                return;
            }
        }
        super.randomTick(state, level, pos, random);
    }

    @Override
    public BlockState flowerState() {
        return (BlockState)this.defaultBlockState().setValue(STATE, (Comparable)((Object)State.FLOWERS));
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)PERSISTENT) != false || state.getValue(STATE) == State.FLOWERS;
    }

    public boolean isBonemealSuccess(Level level, RandomSource r, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource r, BlockPos pos, BlockState state) {
        level.setBlockAndUpdate(pos, (BlockState)state.cycle(STATE));
    }

    protected ConfiguredModel[] buildModel(RegistrateBlockstateProvider pvd, String treeName, BlockState state) {
        String name = treeName + "_" + ((State)((Object)state.getValue(STATE))).getSerializedName();
        return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)pvd.models().withExistingParent(name, "block/leaves")).texture("all", "block/" + name)).build();
    }

    @Override
    public void buildLeavesModel(DataGenContext<Block, ? extends BaseLeavesBlock> ctx, RegistrateBlockstateProvider pvd, String name) {
        pvd.getVariantBuilder((Block)ctx.get()).forAllStatesExcept(state -> this.buildModel(pvd, name, (BlockState)state), new Property[]{LeavesBlock.DISTANCE, LeavesBlock.PERSISTENT, LeavesBlock.WATERLOGGED});
    }

    @Override
    public void buildLoot(RegistrateBlockLootTables pvd, Block block, Block sapling, Item fruit) {
        LootHelper helper = new LootHelper(pvd);
        AnyOfCondition.Builder cond = helper.silk().or(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(Tags.Items.TOOLS_SHEAR)));
        LootPoolSingletonContainer.Builder leaves = (LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when((LootItemCondition.Builder)cond);
        LootPoolSingletonContainer.Builder fruits = ((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)fruit).when(helper.enumState(block, STATE, (Comparable)((Object)State.FRUITS)))).apply(helper.fortuneCount(1));
        LootPoolSingletonContainer.Builder saplings = (LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)sapling).when(helper.fortuneChance(new int[]{20, 16, 12, 10}));
        AlternativesEntry.Builder drops = AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{leaves, fruits, saplings});
        pvd.add(block, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)drops).when(ExplosionCondition.survivesExplosion())));
    }

    public static enum State implements StringRepresentable
    {
        LEAVES,
        FLOWERS,
        FRUITS;


        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

