/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.init.plants;

import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.entry.BlockEntry;
import dev.xkmc.fruitsdelight.content.block.BaseLeavesBlock;
import dev.xkmc.fruitsdelight.init.FruitsDelight;
import dev.xkmc.fruitsdelight.init.plants.Durian;
import dev.xkmc.fruitsdelight.init.plants.FDTreeType;
import dev.xkmc.fruitsdelight.init.plants.FruitPlant;
import dev.xkmc.fruitsdelight.init.plants.PlantDataEntry;
import dev.xkmc.l2core.init.reg.registrate.L2Registrate;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.util.Lazy;

public enum FDTrees implements FruitPlant<FDTrees>
{
    PEAR(() -> Blocks.BIRCH_LOG, FDTreeType.TALL, 3, 0.3f, false, 15),
    HAWBERRY(() -> Blocks.SPRUCE_LOG, FDTreeType.TALL, 2, 0.3f, true, 20),
    LYCHEE(() -> Blocks.JUNGLE_LOG, FDTreeType.TALL, 2, 0.3f, true, 4),
    MANGO(() -> Blocks.JUNGLE_LOG, FDTreeType.NORMAL, 3, 0.3f, false, 4),
    PERSIMMON(() -> Blocks.SPRUCE_LOG, FDTreeType.FANCY, 3, 0.3f, false, 50),
    PEACH(() -> Blocks.JUNGLE_LOG, FDTreeType.PEACH, 3, 0.3f, false, 8),
    ORANGE(() -> Blocks.OAK_LOG, FDTreeType.NORMAL, 3, 0.3f, false, 20),
    APPLE(() -> Blocks.OAK_LOG, FDTreeType.NORMAL, str -> () -> Items.APPLE, 20),
    MANGOSTEEN(() -> Blocks.OAK_LOG, FDTreeType.FANCY, 3, 0.3f, false, 40),
    BAYBERRY(() -> Blocks.SPRUCE_LOG, FDTreeType.TALL, 2, 0.3f, true, 15),
    KIWI(() -> Blocks.JUNGLE_LOG, FDTreeType.NORMAL, 3, 0.3f, true, 20),
    FIG(() -> Blocks.OAK_LOG, FDTreeType.NORMAL, 3, 0.3f, false, 20),
    DURIAN(() -> Blocks.JUNGLE_LOG, FDTreeType.DURIAN, Durian::buildItem, 200);

    private final BlockEntry<? extends BaseLeavesBlock> leaves;
    private final BlockEntry<SaplingBlock> sapling;
    private final Supplier<Item> fruit;
    private final BlockEntry<FlowerPotBlock> pot;
    private final Lazy<TreeConfiguration> treeConfig;
    private final Lazy<TreeConfiguration> treeConfigWild;
    public final ResourceKey<ConfiguredFeature<?, ?>> configKey;
    public final ResourceKey<ConfiguredFeature<?, ?>> configKeyWild;
    public final ResourceKey<PlacedFeature> placementKey;
    public final Supplier<Block> log;
    private final int spawn;
    public boolean genTree = false;

    private FDTrees(Supplier<Block> log, FDTreeType height, Function<String, Supplier<Item>> items, int spawn) {
        this.spawn = spawn;
        String name = this.name().toLowerCase(Locale.ROOT);
        this.log = log;
        this.treeConfig = Lazy.of(() -> this.buildTreeConfig(log, height, false));
        this.treeConfigWild = Lazy.of(() -> this.buildTreeConfig(log, height, true));
        this.configKey = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)FruitsDelight.loc("tree/" + name + "_tree"));
        this.configKeyWild = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)FruitsDelight.loc("tree/" + name + "_tree_wild"));
        this.placementKey = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)FruitsDelight.loc("tree/" + name + "_tree"));
        this.leaves = height.buildLeave(name, this);
        BlockBuilder saplingBuilder = FruitsDelight.REGISTRATE.block(name + "_sapling", p -> new SaplingBlock(new TreeGrower(name, Optional.empty(), Optional.of(this.configKey), Optional.empty()), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING))).blockstate((ctx, pvd) -> pvd.simpleBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)pvd.models().cross(ctx.getName(), pvd.modLoc("block/" + ctx.getName()))).renderType("cutout"))).tag(new TagKey[]{BlockTags.SAPLINGS});
        this.sapling = ((BlockBuilder)height.sapling((BlockBuilder<SaplingBlock, L2Registrate>)saplingBuilder).tag(new TagKey[]{ItemTags.SAPLINGS}).build()).register();
        this.pot = FruitsDelight.REGISTRATE.block("potted_" + name + "_sapling", p -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, this::getSapling, BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY))).blockstate((ctx, pvd) -> pvd.simpleBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)pvd.models().withExistingParent(ctx.getName(), "block/flower_pot_cross")).texture("plant", pvd.modLoc("block/" + name + "_sapling"))).renderType("cutout"))).loot((pvd, block) -> pvd.add((Block)block, pvd.createPotFlowerItemTable((ItemLike)this.getSapling()))).defaultLang().register();
        this.fruit = items.apply(name);
    }

    private FDTrees(Supplier<Block> log, FDTreeType height, int food, float sat, boolean fast, int spawn) {
        this(log, height, name -> ((ItemBuilder)FruitsDelight.REGISTRATE.item(name, p -> new Item(p.food(FDTrees.food(food, sat, fast)))).transform(b -> PlantDataEntry.addFruitTags(name, b))).register(), spawn);
        this.genTree = true;
    }

    public BaseLeavesBlock getLeaves() {
        return (BaseLeavesBlock)((Object)this.leaves.get());
    }

    @Override
    public Item getFruit() {
        return this.fruit.get();
    }

    public SaplingBlock getSapling() {
        return (SaplingBlock)this.sapling.get();
    }

    @Override
    public void registerComposter(BiConsumer<Item, Float> builder) {
        builder.accept(this.getFruit(), Float.valueOf(0.65f));
        builder.accept(this.getLeaves().asItem(), Float.valueOf(0.3f));
        builder.accept(this.getSapling().asItem(), Float.valueOf(0.3f));
        ((FlowerPotBlock)this.pot.get()).getEmptyPot().addPlant(this.sapling.getId(), this.pot);
    }

    @Override
    public void registerConfigs(BootstrapContext<ConfiguredFeature<?, ?>> ctx) {
        ctx.register(this.configKey, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)((TreeConfiguration)this.treeConfig.get())));
        ctx.register(this.configKeyWild, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)((TreeConfiguration)this.treeConfigWild.get())));
    }

    @Override
    public void registerPlacements(BootstrapContext<PlacedFeature> ctx) {
        ctx.register(this.placementKey, (Object)new PlacedFeature((Holder)ctx.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(this.configKeyWild), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)0, (float)(1.0f / ((float)this.spawn + 3.0E-6f)), (int)1), (Block)this.getSapling())));
    }

    @Override
    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public ResourceKey<PlacedFeature> getPlacementKey() {
        return this.placementKey;
    }

    private TreeConfiguration buildTreeConfig(Supplier<Block> log, FDTreeType height, boolean wild) {
        return height.build(log.get(), this.getLeaves(), wild);
    }

    private static FoodProperties food(int food, float sat, boolean fast) {
        FoodProperties.Builder ans = new FoodProperties.Builder().nutrition(food).saturationModifier(sat);
        if (fast) {
            ans.fast();
        }
        return ans.build();
    }

    public static void register() {
    }
}

