/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.init.plants;

import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.RegistrateDataMapProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import dev.xkmc.fruitsdelight.compat.diet.DietTagGen;
import dev.xkmc.fruitsdelight.init.plants.Durian;
import dev.xkmc.fruitsdelight.init.plants.FDBushes;
import dev.xkmc.fruitsdelight.init.plants.FDMelons;
import dev.xkmc.fruitsdelight.init.plants.FDPineapple;
import dev.xkmc.fruitsdelight.init.plants.FDTrees;
import dev.xkmc.l2core.init.reg.registrate.L2Registrate;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.DataMapProvider;
import net.neoforged.neoforge.registries.datamaps.builtin.Compostable;
import net.neoforged.neoforge.registries.datamaps.builtin.NeoForgeDataMaps;

public interface PlantDataEntry<E extends Enum<E>> {
    public static final List<Supplier<PlantDataEntry<?>[]>> LIST = List.of(FDTrees::values, FDBushes::values, FDMelons::values, FDPineapple::values);

    public static <T> void gen(T val, BiConsumer<PlantDataEntry<?>, T> mod) {
        for (Supplier<PlantDataEntry<?>[]> e : LIST) {
            for (PlantDataEntry<?> i : e.get()) {
                mod.accept(i, (PlantDataEntry<?>)val);
            }
        }
    }

    public static void run(Consumer<PlantDataEntry<?>> mod) {
        for (Supplier<PlantDataEntry<?>[]> e : LIST) {
            for (PlantDataEntry<?> i : e.get()) {
                mod.accept(i);
            }
        }
    }

    public static TagKey<Item> getFruitTag(String name) {
        return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("foods/fruits/" + name)));
    }

    public static <T extends Item> ItemBuilder<T, L2Registrate> addFruitTags(String name, ItemBuilder<T, L2Registrate> b) {
        return b.tag(new TagKey[]{Tags.Items.FOODS_FRUIT, DietTagGen.FRUITS.tag, PlantDataEntry.getFruitTag(name)});
    }

    public static void registerComposter(RegistrateDataMapProvider pvd) {
        DataMapProvider.Builder builder = pvd.builder(NeoForgeDataMaps.COMPOSTABLES);
        BiConsumer<Item, Float> cons = (i, f) -> builder.add(BuiltInRegistries.ITEM.wrapAsHolder(i), (Object)new Compostable(f.floatValue(), true), false, new ICondition[0]);
        PlantDataEntry.run(e -> e.registerComposter(cons));
        Durian.registerComposter(cons);
    }

    public void registerComposter(BiConsumer<Item, Float> var1);

    public void registerConfigs(BootstrapContext<ConfiguredFeature<?, ?>> var1);

    public void registerPlacements(BootstrapContext<PlacedFeature> var1);

    public String getName();

    public ResourceKey<PlacedFeature> getPlacementKey();

    default public void genRecipe(RegistrateRecipeProvider pvd) {
    }
}

