/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.events;

import dev.xkmc.cuisinedelight.content.logic.IngredientConfig;
import dev.xkmc.cuisinedelight.init.data.LangData;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="cuisinedelight")
public class EventListeners {
    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.isEmpty()) {
            return;
        }
        IngredientConfig.IngredientEntry config = IngredientConfig.get().getEntry(stack);
        if (config == null) {
            return;
        }
        if (Screen.hasShiftDown()) {
            event.getToolTip().add(config.type.get().withStyle(ChatFormatting.GOLD));
            event.getToolTip().add(LangData.INFO_SIZE.get(config.size));
            event.getToolTip().add(LangData.INFO_NUTRITION.get(config.nutrition));
            event.getToolTip().add(LangData.INFO_MIN_TIME.get(config.min_time / 20));
            event.getToolTip().add(LangData.INFO_MAX_TIME.get(config.max_time / 20));
            event.getToolTip().add(LangData.INFO_STIR_TIME.get(config.stir_time / 20));
            event.getToolTip().add(LangData.INFO_RAW_PENALTY.get(Math.round(config.raw_penalty * 100.0f)));
            event.getToolTip().add(LangData.INFO_OVERCOOK_PENALTY.get(Math.round(config.overcook_penalty * 100.0f)));
            for (IngredientConfig.EffectEntry e : config.effects) {
                MobEffectInstance mobeffectinstance = new MobEffectInstance(e.effect(), e.time());
                MutableComponent mutablecomponent = Component.translatable((String)mobeffectinstance.getDescriptionId());
                MobEffect mobeffect = (MobEffect)mobeffectinstance.getEffect().value();
                if (mobeffectinstance.getDuration() > 20) {
                    mutablecomponent = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, MobEffectUtil.formatDuration((MobEffectInstance)mobeffectinstance, (float)1.0f, (float)20.0f)});
                }
                event.getToolTip().add(mutablecomponent.withStyle(mobeffect.getCategory().getTooltipFormatting()));
            }
        } else {
            event.getToolTip().add(LangData.SHIFT.get(new Object[0]));
        }
    }
}

