/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.init;

import com.tterrag.registrate.providers.ProviderType;
import dev.xkmc.cuisinedelight.content.logic.CookTransformConfig;
import dev.xkmc.cuisinedelight.content.logic.IngredientConfig;
import dev.xkmc.cuisinedelight.init.data.CDConfig;
import dev.xkmc.cuisinedelight.init.data.CDConfigGen;
import dev.xkmc.cuisinedelight.init.data.LangData;
import dev.xkmc.cuisinedelight.init.data.RecipeGen;
import dev.xkmc.cuisinedelight.init.registrate.CDBlocks;
import dev.xkmc.cuisinedelight.init.registrate.CDItems;
import dev.xkmc.cuisinedelight.init.registrate.CDMisc;
import dev.xkmc.l2core.init.reg.registrate.L2Registrate;
import dev.xkmc.l2core.init.reg.simple.Reg;
import dev.xkmc.l2core.serial.config.ConfigTypeEntry;
import dev.xkmc.l2core.serial.config.PacketHandlerWithConfig;
import java.util.function.Function;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.data.loading.DatagenModLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import vectorwing.farmersdelight.common.event.CommonModBusEvents;

@Mod(value="cuisinedelight")
@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="cuisinedelight")
public class CuisineDelight {
    public static final String MODID = "cuisinedelight";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Reg REG = new Reg("cuisinedelight");
    public static final L2Registrate REGISTRATE = new L2Registrate("cuisinedelight");
    public static final PacketHandlerWithConfig HANDLER = new PacketHandlerWithConfig("cuisinedelight", 1, new Function[0]);
    public static final ConfigTypeEntry<IngredientConfig> INGREDIENT = new ConfigTypeEntry(HANDLER, "ingredient", IngredientConfig.class);
    public static final ConfigTypeEntry<CookTransformConfig> TRANSFORM = new ConfigTypeEntry(HANDLER, "transform", CookTransformConfig.class);

    public CuisineDelight() {
        CDItems.register();
        CDBlocks.register();
        CDMisc.register();
        CDConfig.init();
        REGISTRATE.addDataGenerator(ProviderType.RECIPE, RecipeGen::genRecipe);
        REGISTRATE.addDataGenerator(ProviderType.LANG, LangData::genLang);
        if (DatagenModLoader.isRunningDataGen()) {
            ((ModContainer)ModList.get().getModContainerById("farmersdelight").orElseThrow()).getEventBus().unregister(CommonModBusEvents.class);
        }
    }

    public static ResourceLocation loc(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)id);
    }

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {});
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        event.getGenerator().addProvider(event.includeServer(), (DataProvider)new CDConfigGen(event.getGenerator(), event.getLookupProvider()));
    }
}

