/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.next.pipeline.resolver.target;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.next.env.MixinContext;
import org.sinytra.adapter.next.env.ann.MixinData;
import org.sinytra.adapter.next.pipeline.Recipe;
import org.sinytra.adapter.next.pipeline.config.Configuration;
import org.sinytra.adapter.next.pipeline.config.MutableConfiguration;
import org.sinytra.adapter.next.pipeline.resolver.SubResolver;
import org.sinytra.adapter.patch.analysis.InstructionMatcher;
import org.sinytra.adapter.patch.analysis.MethodCallAnalyzer;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.transformer.dynfix.SplitMethodCancellationHelper;
import org.sinytra.adapter.patch.util.MethodQualifier;

public class SplitTargetMethodSubResolver
implements SubResolver {
    @Override
    public Configuration resolve(MixinData mixin, MixinContext context, Configuration clean, Configuration dirty, Recipe recipe) {
        MethodContext.TargetPair cleanTarget = context.methods().findOwnMethodPair(context.cleanLookup(), clean.getTargetMethod());
        MethodContext.TargetPair dirtyTarget = context.methods().findOwnMethodPair(context.dirtyLookup(), clean.getTargetMethod());
        if (dirtyTarget == null) {
            return null;
        }
        List<CandidateMethod> candidates = SplitTargetMethodSubResolver.disambiguate(SplitTargetMethodSubResolver.locateCandidates(context, dirtyTarget), context, cleanTarget);
        if (candidates.size() == 1) {
            MethodNode method = candidates.getFirst().method();
            if (context.legacy().isCancellable()) {
                SplitMethodCancellationHelper.handle(this, context.legacy(), method);
            }
            return MutableConfiguration.create().setTargetMethod(method);
        }
        return null;
    }

    private static List<CandidateMethod> locateCandidates(MixinContext context, MethodContext.TargetPair dirtyTarget) {
        MethodContext methodContext = context.legacy();
        MethodNode cleanTargetMethod = methodContext.findCleanInjectionTarget().methodNode();
        ClassNode dirtyTargetClass = methodContext.findDirtyInjectionTarget().classNode();
        MethodNode dirtyTargetMethod = methodContext.findDirtyInjectionTarget().methodNode();
        if (!MethodCallAnalyzer.isDirtyDeprecatedMethod(cleanTargetMethod, dirtyTargetMethod)) {
            return SplitTargetMethodSubResolver.tryFindPartialCandidates(cleanTargetMethod, dirtyTargetClass, dirtyTargetMethod, methodContext);
        }
        List<MethodNode> invocations = MethodCallAnalyzer.collectMethodInvocations(dirtyTargetClass, dirtyTargetMethod);
        if (invocations == null) {
            return List.of();
        }
        List<CandidateMethod> candidates = SplitTargetMethodSubResolver.findInsnsCalls(invocations, methodContext);
        if (candidates.isEmpty()) {
            List<MethodNode> nestedLambdas = invocations.stream().flatMap(m -> MethodCallAnalyzer.findLambdasInMethod(dirtyTarget.classNode(), m, null).stream()).map(s -> MethodQualifier.create(s).orElseThrow()).flatMap(s -> Optional.ofNullable(context.methods().findOwnMethodPair(context.dirtyLookup(), (MethodQualifier)s)).map(MethodContext.TargetPair::methodNode).stream()).toList();
            return SplitTargetMethodSubResolver.findInsnsCalls(nestedLambdas, methodContext);
        }
        return candidates;
    }

    private static List<CandidateMethod> tryFindPartialCandidates(MethodNode cleanTargetMethod, ClassNode dirtyTargetClass, MethodNode dirtyTargetMethod, MethodContext methodContext) {
        Multimap<String, MethodInsnNode> cleanMethodCalls = MethodCallAnalyzer.getMethodCalls(cleanTargetMethod, new ArrayList<String>());
        Multimap<String, MethodInsnNode> dirtyMethodCalls = MethodCallAnalyzer.getMethodCalls(dirtyTargetMethod, new ArrayList<String>());
        List<MethodNode> dirtyOnlyCalls = dirtyMethodCalls.entries().stream().filter(e -> !cleanMethodCalls.containsKey(e.getKey()) && ((MethodInsnNode)e.getValue()).owner.equals(dirtyTargetClass.name)).map(Map.Entry::getValue).flatMap(i -> MethodCallAnalyzer.findMethodByName(dirtyTargetClass, i.name, i.desc).stream()).toList();
        return SplitTargetMethodSubResolver.findInsnsCalls(dirtyOnlyCalls, methodContext);
    }

    private static List<CandidateMethod> disambiguate(List<CandidateMethod> candidates, MixinContext context, MethodContext.TargetPair cleanTarget) {
        if (candidates.size() <= 1) {
            return candidates;
        }
        List<AbstractInsnNode> cleanInsns = context.methods().findInjectionTargetInsns(cleanTarget);
        if (cleanInsns.size() != 1) {
            return candidates;
        }
        InstructionMatcher cleanMatcher = MethodCallAnalyzer.findSurroundingInstructions(cleanInsns.getFirst(), 5);
        List<CandidateMethod> matchingCandidates = candidates.stream().filter(method -> method.insns().size() == 1).filter(method -> {
            InstructionMatcher matcher = MethodCallAnalyzer.findSurroundingInstructions(method.insns().getFirst(), 5);
            return cleanMatcher.test(matcher, 1);
        }).toList();
        if (matchingCandidates.size() == 1) {
            return matchingCandidates;
        }
        return candidates;
    }

    private static List<CandidateMethod> findInsnsCalls(List<MethodNode> methods, MethodContext methodContext) {
        ClassNode dirtyTargetClass = methodContext.findDirtyInjectionTarget().classNode();
        return methods.stream().map(method -> {
            List<AbstractInsnNode> insns = methodContext.findInjectionTargetInsns(new MethodContext.TargetPair(dirtyTargetClass, (MethodNode)method));
            return !insns.isEmpty() ? new CandidateMethod((MethodNode)method, insns) : null;
        }).filter(Objects::nonNull).toList();
    }

    private record CandidateMethod(MethodNode method, List<AbstractInsnNode> insns) {
    }
}

